/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class ThriftClientConfig {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = new Duration(500.0, TimeUnit.MILLISECONDS);
    public static final Duration DEFAULT_RECEIVE_TIMEOUT = new Duration(1.0, TimeUnit.MINUTES);
    public static final Duration DEFAULT_READ_TIMEOUT = new Duration(10.0, TimeUnit.SECONDS);
    public static final Duration DEFAULT_WRITE_TIMEOUT = new Duration(1.0, TimeUnit.MINUTES);
    public static final int DEFAULT_MAX_FRAME_SIZE = 0x1000000;
    private int maxFrameSize = 0x1000000;
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Duration receiveTimeout = DEFAULT_RECEIVE_TIMEOUT;
    private Duration readTimeout = DEFAULT_READ_TIMEOUT;
    private Duration writeTimeout = DEFAULT_WRITE_TIMEOUT;
    private HostAndPort socksProxy;

    @MinDuration(value="1ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="thrift.client.connect-timeout")
    public ThriftClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @Config(value="thrift.client.receive-timeout")
    public ThriftClientConfig setReceiveTimeout(Duration receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="thrift.client.read-timeout")
    public ThriftClientConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    @Config(value="thrift.client.write-timeout")
    public ThriftClientConfig setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public ThriftClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @Min(value=0L)
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.client.max-frame-size")
    public ThriftClientConfig setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }
}

