/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.RequestChannel;
import com.facebook.swift.service.ThriftClientConfig;
import com.facebook.swift.service.ThriftClientEventHandler;
import com.facebook.swift.service.ThriftClientManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.util.List;
import org.weakref.jmx.Managed;

public class ThriftClient<T> {
    private final ThriftClientManager clientManager;
    private final Class<T> clientType;
    private final String clientName;
    private final Duration connectTimeout;
    private final Duration receiveTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final HostAndPort socksProxy;
    private final int maxFrameSize;
    private final List<? extends ThriftClientEventHandler> eventHandlers;

    @Inject
    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType) {
        this(clientManager, clientType, new ThriftClientConfig(), "default", (List<? extends ThriftClientEventHandler>)ImmutableList.of());
    }

    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType, ThriftClientConfig clientConfig, String clientName) {
        this(clientManager, clientType, clientConfig, clientName, (List<? extends ThriftClientEventHandler>)ImmutableList.of());
    }

    public ThriftClient(ThriftClientManager clientManager, Class<T> clientType, ThriftClientConfig clientConfig, String clientName, List<? extends ThriftClientEventHandler> eventHandlers) {
        Preconditions.checkNotNull((Object)clientManager, (Object)"clientManager is null");
        Preconditions.checkNotNull(clientType, (Object)"clientInterface is null");
        Preconditions.checkNotNull((Object)clientName, (Object)"clientName is null");
        Preconditions.checkNotNull(eventHandlers, (Object)"eventHandlers is null");
        this.clientManager = clientManager;
        this.clientType = clientType;
        this.clientName = clientName;
        this.eventHandlers = eventHandlers;
        this.connectTimeout = clientConfig.getConnectTimeout();
        this.receiveTimeout = clientConfig.getReceiveTimeout();
        this.readTimeout = clientConfig.getReadTimeout();
        this.writeTimeout = clientConfig.getWriteTimeout();
        this.socksProxy = clientConfig.getSocksProxy();
        this.maxFrameSize = clientConfig.getMaxFrameSize();
    }

    @Managed
    public String getClientType() {
        return this.clientType.getName();
    }

    @Managed
    public String getClientName() {
        return this.clientName;
    }

    @Managed
    public String getConnectTimeout() {
        return this.connectTimeout.toString();
    }

    @Managed
    public String getReceiveTimeout() {
        return this.receiveTimeout.toString();
    }

    @Managed
    public String getReadTimeout() {
        return this.readTimeout.toString();
    }

    @Managed
    public String getWriteTimeout() {
        return this.writeTimeout.toString();
    }

    @Managed
    public String getSocksProxy() {
        if (this.socksProxy == null) {
            return null;
        }
        return this.socksProxy.toString();
    }

    @Managed
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public ListenableFuture<T> open(NiftyClientConnector<? extends NiftyClientChannel> connector) {
        return this.clientManager.createClient(connector, this.clientType, this.connectTimeout, this.receiveTimeout, this.readTimeout, this.writeTimeout, this.maxFrameSize, this.clientName, this.eventHandlers, this.getSocksProxyOrDefault());
    }

    public T open(RequestChannel channel) {
        return this.clientManager.createClient(channel, this.clientType, this.clientName, this.eventHandlers);
    }

    private HostAndPort getSocksProxyOrDefault() {
        return this.socksProxy != null ? this.socksProxy : this.clientManager.getDefaultSocksProxy();
    }
}

