/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.client.RequestChannel;
import java.util.concurrent.CountDownLatch;
import org.apache.thrift.TException;
import org.jboss.netty.buffer.ChannelBuffer;

class SyncClientHelpers {
    SyncClientHelpers() {
    }

    public static ChannelBuffer sendSynchronousTwoWayMessage(RequestChannel channel, ChannelBuffer request) throws TException, InterruptedException {
        final ChannelBuffer[] responseHolder = new ChannelBuffer[1];
        final TException[] exceptionHolder = new TException[1];
        final CountDownLatch latch = new CountDownLatch(1);
        responseHolder[0] = null;
        exceptionHolder[0] = null;
        channel.sendAsynchronousRequest(request, false, new RequestChannel.Listener(){

            public void onRequestSent() {
            }

            public void onResponseReceived(ChannelBuffer response) {
                responseHolder[0] = response;
                latch.countDown();
            }

            public void onChannelError(TException e) {
                exceptionHolder[0] = e;
                latch.countDown();
            }
        });
        latch.await();
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
        return responseHolder[0];
    }

    public static void sendSynchronousOneWayMessage(RequestChannel channel, ChannelBuffer request) throws TException, InterruptedException {
        final TException[] exceptionHolder = new TException[1];
        final CountDownLatch latch = new CountDownLatch(1);
        exceptionHolder[0] = null;
        channel.sendAsynchronousRequest(request, true, new RequestChannel.Listener(){

            public void onRequestSent() {
                latch.countDown();
            }

            public void onResponseReceived(ChannelBuffer response) {
            }

            public void onChannelError(TException e) {
                exceptionHolder[0] = e;
                latch.countDown();
            }
        });
        latch.await();
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
    }
}

