/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.core.ClientRequestContext;
import com.facebook.swift.service.ThriftClientEventHandler;
import java.util.ArrayList;
import java.util.List;

public class ClientContextChain {
    private final List<? extends ThriftClientEventHandler> handlers;
    private final String methodName;
    private final List<Object> contexts;

    ClientContextChain(List<? extends ThriftClientEventHandler> handlers, String methodName, ClientRequestContext requestContext) {
        this.handlers = handlers;
        this.methodName = methodName;
        this.contexts = new ArrayList<Object>();
        for (ThriftClientEventHandler thriftClientEventHandler : this.handlers) {
            this.contexts.add(thriftClientEventHandler.getContext(methodName, requestContext));
        }
    }

    public void preWrite(Object[] args) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preWrite(this.contexts.get(i), this.methodName, args);
        }
    }

    public void postWrite(Object[] args) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postWrite(this.contexts.get(i), this.methodName, args);
        }
    }

    public void preRead() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preRead(this.contexts.get(i), this.methodName);
        }
    }

    public void preReadException(Throwable t) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).preReadException(this.contexts.get(i), this.methodName, t);
        }
    }

    public void postRead(Object result) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postRead(this.contexts.get(i), this.methodName, result);
        }
    }

    public void postReadException(Throwable t) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).postReadException(this.contexts.get(i), this.methodName, t);
        }
    }

    public void done() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.handlers.get(i).done(this.contexts.get(i), this.methodName);
        }
    }
}

