/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.reducers.array;

import org.apache.giraph.block_app.reducers.array.HugeArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjectStripingTest {
    private void testStriping(int size, int splits) {
        HugeArrayUtils.ObjectStriping striping = new HugeArrayUtils.ObjectStriping(size, splits);
        int numPerSplit = size / splits;
        int prevSplitIndex = 0;
        int prevInsideIndex = -1;
        Assert.assertEquals((long)0L, (long)striping.getSplitStart(0));
        for (int i = 0; i < size; ++i) {
            int splitIndex = striping.getSplitIndex(i);
            int insideIndex = striping.getInsideIndex(i);
            if (prevInsideIndex + 1 == striping.getSplitSize(prevSplitIndex)) {
                Assert.assertEquals((long)i, (long)striping.getSplitStart(splitIndex));
                Assert.assertEquals((long)splitIndex, (long)(prevSplitIndex + 1));
                Assert.assertEquals((long)insideIndex, (long)0L);
            } else {
                Assert.assertEquals((long)splitIndex, (long)prevSplitIndex);
                Assert.assertEquals((long)insideIndex, (long)(prevInsideIndex + 1));
            }
            int splitSize = striping.getSplitSize(splitIndex);
            if (splitSize != numPerSplit && splitSize != numPerSplit + 1) {
                Assert.fail((String)(splitSize + " " + numPerSplit));
            }
            prevSplitIndex = splitIndex;
            prevInsideIndex = insideIndex;
        }
        Assert.assertEquals((long)(prevSplitIndex + 1), (long)splits);
        Assert.assertEquals((long)(prevInsideIndex + 1), (long)striping.getSplitSize(prevSplitIndex));
    }

    @Test
    public void test() {
        this.testStriping(5, 5);
        this.testStriping(6, 5);
        this.testStriping(7, 5);
        this.testStriping(9, 5);
        this.testStriping(10, 5);
        this.testStriping(100, 5);
        this.testStriping(101, 5);
        this.testStriping(104, 5);
    }
}

