/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework.block;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.BlockTestingUtils;
import org.apache.giraph.block_app.framework.block.RepeatBlock;
import org.apache.giraph.block_app.framework.block.RepeatUntilBlock;
import org.apache.giraph.block_app.framework.block.SequenceBlock;
import org.apache.giraph.block_app.framework.piece.AbstractPiece;
import org.apache.giraph.block_app.framework.piece.Piece;
import org.apache.giraph.function.Supplier;
import org.apache.giraph.function.primitive.PrimitiveRefs;
import org.junit.Assert;
import org.junit.Test;

public class TestRepeatUntilBlock {
    public static final int REPEAT_TIMES = 5;
    private static final Supplier<Boolean> falseSupplier = new Supplier<Boolean>(){

        public Boolean get() {
            return false;
        }
    };

    @Test
    public void testRepeatUntilBlockBasic() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        SequenceBlock innerBlock = new SequenceBlock(new Block[]{piece1, piece2});
        RepeatUntilBlock repeatBlock = new RepeatUntilBlock(5, (Block)innerBlock, falseSupplier);
        BlockTestingUtils.testIndependence(Iterables.concat(Collections.nCopies(5, Arrays.asList(piece1, piece2))), (Iterable<? extends AbstractPiece>)repeatBlock);
        Assert.assertEquals((long)2L, (long)innerBlock.getPieceCount().getCount());
        Assert.assertFalse((boolean)repeatBlock.getPieceCount().isKnown());
    }

    @Test
    public void testRepeatUntilBlockBasicExit() throws Exception {
        this.testRepeatUntilBlockBasicExit(1, 1);
        this.testRepeatUntilBlockBasicExit(1, 3);
        this.testRepeatUntilBlockBasicExit(3, 1);
        this.testRepeatUntilBlockBasicExit(3, 2);
        this.testRepeatUntilBlockBasicExit(4, 7);
    }

    private void testRepeatUntilBlockBasicExit(int inner, int outer) {
        final PrimitiveRefs.IntRef counter = new PrimitiveRefs.IntRef(outer + 1);
        Supplier<Boolean> countDown = new Supplier<Boolean>(){

            public Boolean get() {
                --counter.value;
                return counter.value == 0;
            }
        };
        Piece piece = new Piece();
        RepeatUntilBlock repeatBlock = new RepeatUntilBlock(outer + 4, (Block)new RepeatBlock(inner, (Block)piece), (Supplier)countDown);
        BlockTestingUtils.testSequential(Iterables.concat((Iterable[])new Iterable[]{Collections.nCopies(outer * inner, piece)}), (Iterable<? extends AbstractPiece>)repeatBlock);
    }

    @Test
    public void testNestedRepeatUntilBlock() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        SequenceBlock innerBlock = new SequenceBlock(new Block[]{piece1, piece2});
        RepeatUntilBlock repeatBlock = new RepeatUntilBlock(5, (Block)innerBlock, falseSupplier);
        BlockTestingUtils.testNestedRepeatBlock(Iterables.concat(Collections.nCopies(5, Arrays.asList(piece1, piece2))), (Block)repeatBlock);
    }

    @Test
    public void testRepeatUntilBlockUnlimited() throws Exception {
        SequenceBlock innerBlock = new SequenceBlock(new Block[]{new Piece()});
        Supplier<Boolean> countingSupplier = new Supplier<Boolean>(){
            private int i = 0;

            public Boolean get() {
                ++this.i;
                return this.i > 5;
            }
        };
        Block repeatBlock = RepeatUntilBlock.unlimited((Block)innerBlock, (Supplier)countingSupplier);
        int count = 0;
        Iterator it = repeatBlock.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        Assert.assertEquals((String)"Count must be equal to REPEAT_TIMES", (long)5L, (long)count);
    }
}

