/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework.block;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.BlockTestingUtils;
import org.apache.giraph.block_app.framework.block.EmptyBlock;
import org.apache.giraph.block_app.framework.block.RepeatBlock;
import org.apache.giraph.block_app.framework.block.SequenceBlock;
import org.apache.giraph.block_app.framework.piece.AbstractPiece;
import org.apache.giraph.block_app.framework.piece.Piece;
import org.junit.Assert;
import org.junit.Test;

public class TestRepeatBlock {
    public static final int REPEAT_TIMES = 5;

    @Test
    public void testRepeatBlockBasic() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        SequenceBlock innerBlock = new SequenceBlock(new Block[]{piece1, piece2});
        RepeatBlock repeatBlock = new RepeatBlock(5, (Block)innerBlock);
        BlockTestingUtils.testIndependence(Iterables.concat(Collections.nCopies(5, Arrays.asList(piece1, piece2))), (Iterable<? extends AbstractPiece>)repeatBlock);
        Assert.assertEquals((long)10L, (long)repeatBlock.getPieceCount().getCount());
    }

    @Test
    public void testNestedRepeatBlock() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        SequenceBlock innerBlock = new SequenceBlock(new Block[]{piece1, piece2});
        RepeatBlock repeatBlock = new RepeatBlock(5, (Block)innerBlock);
        BlockTestingUtils.testNestedRepeatBlock(Iterables.concat(Collections.nCopies(5, Arrays.asList(piece1, piece2))), (Block)repeatBlock);
    }

    @Test
    public void testRepeatBlockEmpty() throws Exception {
        EmptyBlock innerBlock = new EmptyBlock();
        RepeatBlock repeatBlock = new RepeatBlock(5, (Block)innerBlock);
        List referenceImpl = Collections.emptyList();
        BlockTestingUtils.testIndependence(referenceImpl, (Iterable<? extends AbstractPiece>)repeatBlock);
    }
}

