/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework.block;

import java.util.Arrays;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.BlockTestingUtils;
import org.apache.giraph.block_app.framework.block.EmptyBlock;
import org.apache.giraph.block_app.framework.block.IfBlock;
import org.apache.giraph.block_app.framework.block.SequenceBlock;
import org.apache.giraph.block_app.framework.piece.AbstractPiece;
import org.apache.giraph.block_app.framework.piece.Piece;
import org.apache.giraph.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class TestIfBlock {
    private static final Supplier<Boolean> TRUE_SUPPLIER = new Supplier<Boolean>(){

        public Boolean get() {
            return true;
        }
    };
    private static final Supplier<Boolean> FALSE_SUPPLIER = new Supplier<Boolean>(){

        public Boolean get() {
            return false;
        }
    };

    @Test
    public void testIfBlockThen() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        IfBlock ifBlock = new IfBlock(TRUE_SUPPLIER, (Block)new SequenceBlock(new Block[]{piece1, piece2}));
        BlockTestingUtils.testIndependence(Arrays.asList(piece1, piece2), (Iterable<? extends AbstractPiece>)ifBlock);
        Assert.assertFalse((boolean)ifBlock.getPieceCount().isKnown());
    }

    @Test
    public void testIfBlockElse() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        IfBlock ifBlock = new IfBlock(FALSE_SUPPLIER, (Block)new EmptyBlock(), (Block)new SequenceBlock(new Block[]{piece1, piece2}));
        BlockTestingUtils.testIndependence(Arrays.asList(piece1, piece2), (Iterable<? extends AbstractPiece>)ifBlock);
        Assert.assertFalse((boolean)ifBlock.getPieceCount().isKnown());
    }

    @Test
    public void testIfNestedInRepeat() throws Exception {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        IfBlock ifBlock = new IfBlock(TRUE_SUPPLIER, (Block)new SequenceBlock(new Block[]{piece1, piece2}));
        BlockTestingUtils.testNestedRepeatBlock(Arrays.asList(piece1, piece2), (Block)ifBlock);
        Assert.assertFalse((boolean)ifBlock.getPieceCount().isKnown());
    }

    @Test
    public void testIfThenElsePieceCount() {
        Piece piece1 = new Piece();
        Piece piece2 = new Piece();
        IfBlock ifBlock = new IfBlock(TRUE_SUPPLIER, (Block)piece1, (Block)piece2);
        Assert.assertTrue((boolean)ifBlock.getPieceCount().isKnown());
        Assert.assertEquals((long)1L, (long)ifBlock.getPieceCount().getCount());
    }
}

