/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.RepeatBlock;
import org.apache.giraph.block_app.framework.piece.AbstractPiece;
import org.junit.Assert;

public class BlockTestingUtils {
    private static final int NUM_TRIALS = 10;
    private static final int REPEAT_TIMES = 10;

    BlockTestingUtils() {
    }

    public static int testSequential(Iterable<? extends AbstractPiece> referenceImpl, Iterable<? extends AbstractPiece> testImpl) {
        int length = 0;
        CheckIterator<? extends AbstractPiece> checkIterator = new CheckIterator<AbstractPiece>(referenceImpl.iterator(), testImpl.iterator());
        while (checkIterator.hasNext()) {
            checkIterator.next();
            ++length;
        }
        System.out.println("Length is : " + length);
        return length;
    }

    private static boolean anyHasNext(ArrayList<? extends Iterator> arr) {
        for (Iterator iterator : arr) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    private static void testRandom(int length, Iterable<? extends AbstractPiece> referenceImpl, Iterable<? extends AbstractPiece> testImpl) {
        int i;
        Random rand = new Random();
        ArrayList<CheckIterator<? extends AbstractPiece>> arr = new ArrayList<CheckIterator<? extends AbstractPiece>>();
        IntArrayList lengths = new IntArrayList(10);
        for (i = 0; i < 10; ++i) {
            lengths.add(0);
        }
        for (i = 0; i < 10; ++i) {
            arr.add(new CheckIterator<AbstractPiece>(referenceImpl.iterator(), testImpl.iterator()));
        }
        int totalCount = 0;
        while (BlockTestingUtils.anyHasNext(arr)) {
            int index = rand.nextInt(10);
            while (!((CheckIterator)arr.get(index)).hasNext()) {
                index = rand.nextInt(10);
            }
            CheckIterator it = (CheckIterator)arr.get(index);
            it.next();
            int itLength = lengths.getInt(index);
            lengths.set(index, itLength + 1);
            ++totalCount;
        }
        Assert.assertEquals((String)"TotalCount should be length * NUM_TRIALS", (long)(length * 10), (long)totalCount);
        System.out.println("Final count is : " + totalCount);
    }

    public static void testIndependence(Iterable<? extends AbstractPiece> referenceImpl, Iterable<? extends AbstractPiece> testImpl) {
        int length = BlockTestingUtils.testSequential(referenceImpl, testImpl);
        BlockTestingUtils.testRandom(length, referenceImpl, testImpl);
    }

    public static void testNestedRepeatBlock(Iterable<? extends AbstractPiece> referenceImpl, Block block) {
        RepeatBlock repeatBlock = new RepeatBlock(10, block);
        BlockTestingUtils.testIndependence(Iterables.concat(Collections.nCopies(10, referenceImpl)), (Iterable<? extends AbstractPiece>)repeatBlock);
    }

    public static class CheckIterator<T>
    implements Iterator {
        private final Iterator<T> fst;
        private final Iterator<T> snd;

        public CheckIterator(Iterator<T> fst, Iterator<T> snd) {
            this.fst = fst;
            this.snd = snd;
        }

        @Override
        public boolean hasNext() {
            boolean sndHasNxt;
            boolean fstHasNxt = this.fst.hasNext();
            Preconditions.checkArgument((fstHasNxt == (sndHasNxt = this.snd.hasNext()) ? 1 : 0) != 0, (Object)("Expect hasNext() on both iterators to be identical. Got: " + this.fst.hasNext() + " and " + this.snd.hasNext()));
            return fstHasNxt;
        }

        public Object next() {
            T sndNxt;
            T fstNxt = this.fst.next();
            Preconditions.checkArgument((fstNxt == (sndNxt = this.snd.next()) ? 1 : 0) != 0, (Object)("Expect objs returned by both iterators to be identical. Got: " + fstNxt + " and " + sndNxt));
            return fstNxt;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented");
        }
    }
}

