/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework;

import java.util.HashSet;
import java.util.List;
import org.apache.giraph.block_app.framework.BlockUtils;
import org.apache.giraph.block_app.framework.TestLongNullNullBlockFactory;
import org.apache.giraph.block_app.framework.api.BlockWorkerContextReceiveApi;
import org.apache.giraph.block_app.framework.api.BlockWorkerContextSendApi;
import org.apache.giraph.block_app.framework.api.local.LocalBlockRunner;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.SequenceBlock;
import org.apache.giraph.block_app.framework.piece.PieceWithWorkerContext;
import org.apache.giraph.block_app.test_setup.NumericTestGraph;
import org.apache.giraph.block_app.test_setup.TestGraphModifier;
import org.apache.giraph.block_app.test_setup.TestGraphUtils;
import org.apache.giraph.conf.BulkConfigurator;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.types.NoMessage;
import org.apache.giraph.utils.TestGraph;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class TestWorkerMessages {
    @Test
    public void testWorkerMessages() throws Exception {
        GiraphConfiguration conf = new GiraphConfiguration();
        BlockUtils.setAndInitBlockFactoryClass((GiraphConfiguration)conf, TestWorkerMessagesBlockFactory.class);
        TestGraph testGraph = new TestGraph(conf);
        testGraph.addEdge((WritableComparable)new LongWritable(1L), (WritableComparable)new LongWritable(2L), (Writable)NullWritable.get());
        LocalBlockRunner.runApp((TestGraph)testGraph);
    }

    @Test
    public void testWithTestSetup() throws Exception {
        TestGraphUtils.runTest((TestGraphModifier)new TestGraphModifier<WritableComparable, Writable, Writable>(){

            public void modifyGraph(NumericTestGraph<WritableComparable, Writable, Writable> graph) {
                graph.addEdge((Number)1, (Number)2);
            }
        }, null, (BulkConfigurator)new BulkConfigurator(){

            public void configure(GiraphConfiguration conf) {
                BlockUtils.setBlockFactoryClass((Configuration)conf, TestWorkerMessagesBlockFactory.class);
            }
        });
    }

    public static class TestWorkerMessagesPiece
    extends PieceWithWorkerContext<LongWritable, Writable, Writable, NoMessage, Object, LongWritable, Object> {
        private final HashSet<Long> values = new HashSet();

        public TestWorkerMessagesPiece(long ... values) {
            for (long value : values) {
                this.values.add(value);
            }
        }

        public void workerContextSend(BlockWorkerContextSendApi<LongWritable, LongWritable> workerContextApi, Object executionStage, Object workerValue) {
            for (long value : this.values) {
                workerContextApi.sendMessageToWorker((Writable)new LongWritable(value), workerContextApi.getMyWorkerIndex());
            }
        }

        public void workerContextReceive(BlockWorkerContextReceiveApi workerContextApi, Object executionStage, Object workerValue, List<LongWritable> workerMessages) {
            Assert.assertEquals((long)this.values.size(), (long)workerMessages.size());
            for (LongWritable workerMessage : workerMessages) {
                Assert.assertTrue((boolean)this.values.remove(workerMessage.get()));
            }
        }
    }

    public static class TestWorkerMessagesBlockFactory
    extends TestLongNullNullBlockFactory {
        public Block createBlock(GiraphConfiguration conf) {
            return new SequenceBlock(new Block[]{new TestWorkerMessagesPiece(2L, 4L, 11L), new TestWorkerMessagesPiece(3L, 5L, 2L, 100L)});
        }
    }
}

