/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework;

import org.apache.giraph.block_app.framework.BlockUtils;
import org.apache.giraph.block_app.framework.TestLongNullNullBlockFactory;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.library.Pieces;
import org.apache.giraph.block_app.library.VertexSuppliers;
import org.apache.giraph.block_app.test_setup.NumericTestGraph;
import org.apache.giraph.block_app.test_setup.TestGraphChecker;
import org.apache.giraph.block_app.test_setup.TestGraphModifier;
import org.apache.giraph.block_app.test_setup.TestGraphUtils;
import org.apache.giraph.conf.BulkConfigurator;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.function.vertex.ConsumerWithVertex;
import org.apache.giraph.function.vertex.SupplierFromVertex;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class SendingMessagesTest {
    @Test
    public void createVertexOnMsgsTest() throws Exception {
        TestGraphUtils.runTest((TestGraphModifier)new TestGraphModifier<LongWritable, LongWritable, Writable>(){

            public void modifyGraph(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                graph.addEdge((Number)1, (Number)2);
            }
        }, (TestGraphChecker)new TestGraphChecker<LongWritable, LongWritable, Writable>(){

            public void checkOutput(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                Assert.assertEquals((long)1L, (long)((LongWritable)graph.getValue((Number)2)).get());
                Assert.assertEquals((long)0L, (long)((LongWritable)graph.getValue((Number)1)).get());
            }
        }, (BulkConfigurator)new BulkConfigurator(){

            public void configure(GiraphConfiguration conf) {
                BlockUtils.setBlockFactoryClass((Configuration)conf, SendingMessagesToNeighborsBlockFactory.class);
            }
        });
    }

    @Test
    public void doNotCreateVertexOnMsgsTest() throws Exception {
        TestGraphUtils.runTest((TestGraphModifier)new TestGraphModifier<LongWritable, LongWritable, Writable>(){

            public void modifyGraph(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                graph.addEdge((Number)1, (Number)2);
            }
        }, (TestGraphChecker)new TestGraphChecker<LongWritable, LongWritable, Writable>(){

            public void checkOutput(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                Assert.assertNull((Object)graph.getVertex((Number)2));
                Assert.assertEquals((long)0L, (long)((LongWritable)graph.getValue((Number)1)).get());
            }
        }, (BulkConfigurator)new BulkConfigurator(){

            public void configure(GiraphConfiguration conf) {
                BlockUtils.setBlockFactoryClass((Configuration)conf, SendingMessagesToNeighborsBlockFactory.class);
                GiraphConstants.RESOLVER_CREATE_VERTEX_ON_MSGS.set((Configuration)conf, false);
            }
        });
    }

    @Test
    public void createMultiMsgs() throws Exception {
        TestGraphUtils.runTest((TestGraphModifier)new TestGraphModifier<LongWritable, LongWritable, Writable>(){

            public void modifyGraph(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                graph.addSymmetricEdge((Number)1, (Number)2);
                graph.addSymmetricEdge((Number)3, (Number)2);
            }
        }, (TestGraphChecker)new TestGraphChecker<LongWritable, LongWritable, Writable>(){

            public void checkOutput(NumericTestGraph<LongWritable, LongWritable, Writable> graph) {
                Assert.assertEquals((long)3L, (long)((LongWritable)graph.getValue((Number)2)).get());
                Assert.assertEquals((long)2L, (long)((LongWritable)graph.getValue((Number)1)).get());
                Assert.assertEquals((long)2L, (long)((LongWritable)graph.getValue((Number)3)).get());
            }
        }, (BulkConfigurator)new BulkConfigurator(){

            public void configure(GiraphConfiguration conf) {
                BlockUtils.setBlockFactoryClass((Configuration)conf, SendingMessagesToNeighborsBlockFactory.class);
            }
        });
    }

    public static class SendingMessagesToNeighborsBlockFactory
    extends TestLongNullNullBlockFactory {
        @Override
        protected Class<? extends Writable> getVertexValueClass(GiraphConfiguration conf) {
            return LongWritable.class;
        }

        public Block createBlock(GiraphConfiguration conf) {
            return Pieces.sendMessageToNeighbors((String)"SendToNeighbors", LongWritable.class, (SupplierFromVertex)VertexSuppliers.vertexIdSupplier(), (ConsumerWithVertex)new ConsumerWithVertex<LongWritable, LongWritable, Writable, Iterable<LongWritable>>(){

                public void apply(Vertex<LongWritable, LongWritable, Writable> vertex, Iterable<LongWritable> messages) {
                    long max = 0L;
                    for (LongWritable v : messages) {
                        max = Math.max(max, v.get());
                    }
                    ((LongWritable)vertex.getValue()).set(max);
                }
            });
        }
    }
}

