/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework;

import org.apache.giraph.block_app.framework.BlockUtils;
import org.apache.giraph.block_app.framework.TestLongNullNullBlockFactory;
import org.apache.giraph.block_app.framework.api.BlockWorkerSendApi;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.piece.Piece;
import org.apache.giraph.block_app.framework.piece.interfaces.VertexSender;
import org.apache.giraph.block_app.test_setup.NumericTestGraph;
import org.apache.giraph.block_app.test_setup.TestGraphChecker;
import org.apache.giraph.block_app.test_setup.TestGraphModifier;
import org.apache.giraph.block_app.test_setup.TestGraphUtils;
import org.apache.giraph.conf.BulkConfigurator;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class MultipleSimultanousMutationsTest {
    @Test
    public void createVertexOnMsgsTest() throws Exception {
        TestGraphUtils.runTest((TestGraphModifier)new TestGraphModifier<LongWritable, Writable, LongWritable>(){

            public void modifyGraph(NumericTestGraph<LongWritable, Writable, LongWritable> graph) {
                graph.addEdge((Number)1, (Number)2, (Number)2);
            }
        }, (TestGraphChecker)new TestGraphChecker<LongWritable, Writable, LongWritable>(){

            public void checkOutput(NumericTestGraph<LongWritable, Writable, LongWritable> graph) {
                Assert.assertEquals((long)1L, (long)graph.getVertex((Number)1).getNumEdges());
                Assert.assertNull((Object)graph.getVertex((Number)1).getEdgeValue((WritableComparable)new LongWritable(-1L)));
                Assert.assertEquals((long)2L, (long)((LongWritable)graph.getVertex((Number)1).getEdgeValue((WritableComparable)new LongWritable(2L))).get());
                Assert.assertEquals((long)1L, (long)graph.getVertex((Number)2).getNumEdges());
                Assert.assertEquals((long)-1L, (long)((LongWritable)graph.getVertex((Number)2).getEdgeValue((WritableComparable)new LongWritable(-1L))).get());
            }
        }, (BulkConfigurator)new BulkConfigurator(){

            public void configure(GiraphConfiguration conf) {
                BlockUtils.setBlockFactoryClass((Configuration)conf, SendingAndAddEdgeBlockFactory.class);
            }
        });
    }

    public static class SendingAndAddEdgeBlockFactory
    extends TestLongNullNullBlockFactory {
        @Override
        protected Class<? extends Writable> getEdgeValueClass(GiraphConfiguration conf) {
            return LongWritable.class;
        }

        public Block createBlock(GiraphConfiguration conf) {
            return new Piece<LongWritable, Writable, LongWritable, NullWritable, Object>(){

                protected Class<NullWritable> getMessageClass() {
                    return NullWritable.class;
                }

                public VertexSender<LongWritable, Writable, LongWritable> getVertexSender(final BlockWorkerSendApi<LongWritable, Writable, LongWritable, NullWritable> workerApi, Object executionStage) {
                    final ReusableEdge reusableEdge = workerApi.getConf().createReusableEdge();
                    reusableEdge.setTargetVertexId((WritableComparable)new LongWritable(-1L));
                    reusableEdge.setValue((Writable)new LongWritable(-1L));
                    return new VertexSender<LongWritable, Writable, LongWritable>(){

                        public void vertexSend(Vertex<LongWritable, Writable, LongWritable> vertex) {
                            for (Edge edge : vertex.getEdges()) {
                                workerApi.addEdgeRequest((WritableComparable)((LongWritable)edge.getTargetVertexId()), (Edge)reusableEdge);
                                workerApi.sendMessage((WritableComparable)((LongWritable)edge.getTargetVertexId()), (Writable)NullWritable.get());
                            }
                        }
                    };
                }
            };
        }
    }
}

