/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.block_app.framework;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.giraph.block_app.framework.BlockUtils;
import org.apache.giraph.block_app.framework.api.BlockApiHandle;
import org.apache.giraph.block_app.framework.api.BlockMasterApi;
import org.apache.giraph.block_app.framework.api.BlockWorkerContextReceiveApi;
import org.apache.giraph.block_app.framework.api.BlockWorkerContextSendApi;
import org.apache.giraph.block_app.framework.api.BlockWorkerReceiveApi;
import org.apache.giraph.block_app.framework.api.BlockWorkerSendApi;
import org.apache.giraph.block_app.framework.api.local.LocalBlockRunner;
import org.apache.giraph.block_app.framework.block.Block;
import org.apache.giraph.block_app.framework.block.BlockWithApiHandle;
import org.apache.giraph.block_app.framework.block.PieceCount;
import org.apache.giraph.block_app.framework.piece.AbstractPiece;
import org.apache.giraph.block_app.framework.piece.DefaultParentPiece;
import org.apache.giraph.block_app.framework.piece.interfaces.VertexReceiver;
import org.apache.giraph.block_app.framework.piece.interfaces.VertexSender;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.function.Consumer;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.TestGraph;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class BlockApiHandleTest {
    private static GiraphConfiguration createConf() {
        GiraphConfiguration conf = new GiraphConfiguration();
        GiraphConstants.VERTEX_ID_CLASS.set((Configuration)conf, LongWritable.class);
        GiraphConstants.VERTEX_VALUE_CLASS.set((Configuration)conf, LongWritable.class);
        GiraphConstants.EDGE_VALUE_CLASS.set((Configuration)conf, NullWritable.class);
        return conf;
    }

    private static TestGraph<LongWritable, LongWritable, NullWritable> createTestGraph() {
        TestGraph graph = new TestGraph(BlockApiHandleTest.createConf());
        graph.addVertex((WritableComparable)new LongWritable(1L), (Writable)new LongWritable(), new Map.Entry[0]);
        graph.addVertex((WritableComparable)new LongWritable(2L), (Writable)new LongWritable(), new Map.Entry[0]);
        graph.addVertex((WritableComparable)new LongWritable(3L), (Writable)new LongWritable(), new Map.Entry[0]);
        graph.addVertex((WritableComparable)new LongWritable(4L), (Writable)new LongWritable(), new Map.Entry[0]);
        graph.addEdge((WritableComparable)new LongWritable(1L), (WritableComparable)new LongWritable(2L), (Writable)NullWritable.get());
        graph.addEdge((WritableComparable)new LongWritable(2L), (WritableComparable)new LongWritable(1L), (Writable)NullWritable.get());
        graph.addEdge((WritableComparable)new LongWritable(2L), (WritableComparable)new LongWritable(3L), (Writable)NullWritable.get());
        graph.addEdge((WritableComparable)new LongWritable(3L), (WritableComparable)new LongWritable(2L), (Writable)NullWritable.get());
        return graph;
    }

    @Test
    public void testBlockApiHandle() {
        TestGraph<LongWritable, LongWritable, NullWritable> graph = BlockApiHandleTest.createTestGraph();
        final BlockApiHandle handle = new BlockApiHandle();
        final TestPiece piece = new TestPiece(new DummyObjectWithApiHandle(handle));
        BlockWithApiHandle block = new BlockWithApiHandle(){

            public Iterator<AbstractPiece> iterator() {
                return piece.iterator();
            }

            public void forAllPossiblePieces(Consumer<AbstractPiece> consumer) {
                piece.forAllPossiblePieces(consumer);
            }

            public PieceCount getPieceCount() {
                return piece.getPieceCount();
            }

            public BlockApiHandle getBlockApiHandle() {
                return handle;
            }
        };
        BlockUtils.BLOCK_WORKER_CONTEXT_VALUE_CLASS.set((Configuration)graph.getConf(), Object.class);
        LocalBlockRunner.runBlock(graph, (Block)block, (Object)new Object());
    }

    public static class TestPiece
    extends DefaultParentPiece<WritableComparable, LongWritable, Writable, NullWritable, Object, DoubleWritable, Object> {
        private DummyObjectWithApiHandle object;

        public TestPiece(DummyObjectWithApiHandle object) {
            this.object = object;
        }

        public VertexSender<WritableComparable, LongWritable, Writable> getVertexSender(BlockWorkerSendApi<WritableComparable, LongWritable, Writable, NullWritable> workerApi, Object executionStage) {
            return new AbstractPiece.InnerVertexSender(){

                public void vertexSend(Vertex<WritableComparable, LongWritable, Writable> vertex) {
                    object.doSomethingAtWorker();
                }
            };
        }

        public VertexReceiver<WritableComparable, LongWritable, Writable, NullWritable> getVertexReceiver(BlockWorkerReceiveApi<WritableComparable> workerApi, Object executionStage) {
            return new AbstractPiece.InnerVertexReceiver(){

                public void vertexReceive(Vertex<WritableComparable, LongWritable, Writable> vertex, Iterable<NullWritable> messages) {
                    object.doSomethingAtWorker();
                }
            };
        }

        public void workerContextSend(BlockWorkerContextSendApi<WritableComparable, DoubleWritable> workerContextApi, Object executionStage, Writable workerValue) {
            this.object.doSomethingAtWorkerContext();
        }

        public void workerContextReceive(BlockWorkerContextReceiveApi workerContextApi, Object executionStage, Object workerValue, List<DoubleWritable> workerMessages) {
            this.object.doSomethingAtWorkerContext();
        }

        public void masterCompute(BlockMasterApi masterApi, Object executionStage) {
            this.object.doSomethingAtMaster();
        }

        protected Class<NullWritable> getMessageClass() {
            return NullWritable.class;
        }
    }

    public static class DummyObjectWithApiHandle {
        private BlockApiHandle handle;

        public DummyObjectWithApiHandle(BlockApiHandle handle) {
            this.handle = handle;
        }

        public void doSomethingAtWorker() {
            Assert.assertFalse((boolean)this.handle.isMasterApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerContextReceiveApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerContextSendApiSet());
            Assert.assertEquals((long)1L, (long)this.handle.getWorkerReceiveApi().getWorkerCount());
            Assert.assertEquals((long)0L, (long)this.handle.getWorkerSendApi().getMyWorkerIndex());
        }

        public void doSomethingAtWorkerContext() {
            Assert.assertFalse((boolean)this.handle.isMasterApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerReceiveApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerSendApiSet());
            Assert.assertEquals((long)1L, (long)this.handle.getWorkerContextReceiveApi().getWorkerCount());
            Assert.assertEquals((long)0L, (long)this.handle.getWorkerContextSendApi().getMyWorkerIndex());
        }

        public void doSomethingAtMaster() {
            Assert.assertEquals((long)1L, (long)this.handle.getMasterApi().getWorkerCount());
            Assert.assertFalse((boolean)this.handle.isWorkerReceiveApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerSendApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerContextReceiveApiSet());
            Assert.assertFalse((boolean)this.handle.isWorkerContextSendApiSet());
        }
    }
}

