/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.testsupport.commands;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geronimo.mavenplugins.geronimo.ServerProxy;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;

public class CommandTestSupport {
    public static final String GSH = "gsh";
    public static final String DEPLOY = "deploy";
    protected static final long timeout = 30000L;
    protected static String geronimoHome = CommandTestSupport.getGeronimoHome();

    private static String getGeronimoHome() {
        ServerProxy server = null;
        try {
            server = new ServerProxy("localhost", 1099, "system", "manager");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to setup ServerProxy", e);
        }
        String home = server.getGeronimoHome();
        Throwable exception = server.getLastError();
        server.closeConnection();
        if (exception != null) {
            throw new RuntimeException("Failed to get Geronimo home", exception);
        }
        return home;
    }

    public void execute(String command, String[] args, InputStream in, OutputStream out) throws Exception {
        this.execute(command, args == null ? null : Arrays.asList(args), in, out);
    }

    public void execute(String command, List<String> args, InputStream in, OutputStream out) throws Exception {
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (this.isWindows()) {
            cmdLine.add("cmd.exe");
            cmdLine.add("/c");
        }
        cmdLine.add(this.resolveCommandForOS(command));
        cmdLine.addAll(this.getCommandArguments(command));
        if (args != null) {
            cmdLine.addAll(args);
        }
        ExecuteWatchdog watchdog = new ExecuteWatchdog(30000L);
        PumpStreamHandler streamHandler = new PumpStreamHandler(out, out, in);
        Execute exec = new Execute((ExecuteStreamHandler)streamHandler, watchdog);
        exec.setCommandline(cmdLine.toArray(new String[0]));
        List<String> env = this.getCommandEnvironment(command);
        if (!env.isEmpty()) {
            exec.setEnvironment(env.toArray(new String[0]));
        }
        exec.execute();
    }

    protected List<String> getCommandArguments(String command) {
        if (GSH.equals(command)) {
            return Arrays.asList("-T", "false");
        }
        return Collections.emptyList();
    }

    protected List<String> getCommandEnvironment(String command) {
        if (DEPLOY.equals(command)) {
            return Arrays.asList("JAVA_OPTS=-Djline.terminal=jline.UnsupportedTerminal");
        }
        return Collections.emptyList();
    }

    protected String resolveCommandForOS(String command) {
        String filename = "";
        if (this.isWindows()) {
            filename = geronimoHome + "/bin/" + command + ".bat";
        } else {
            try {
                File cmdfile1 = new File(geronimoHome + "/bin/" + command);
                File cmdfile2 = new File(geronimoHome + "/bin/" + command + ".sh");
                if (cmdfile1.exists()) {
                    filename = geronimoHome + "/bin/" + command;
                } else if (cmdfile2.exists()) {
                    filename = geronimoHome + "/bin/" + command + ".sh";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filename;
    }

    public boolean isWindows() {
        return Os.isFamily((String)"windows");
    }
}

