/*
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
     http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
*/
package org.apache.geronimo.samples.javaee6.singletonejb.backbeans;

import org.apache.geronimo.samples.javaee6.singletonejb.sessionBeans.SingletonCalculator;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;


@ManagedBean(name = "SubtractSingletonCalculatorBackBean")
@RequestScoped
public class SubtractCalculatorBackBean {

    @EJB
    private SingletonCalculator calculatorfacade;
    private String currentInput = "0.0";
    private String output;

    /** Creates a new instance of SingletonCalculatorBackBean */
    public SubtractCalculatorBackBean() {
        currentInput = "1.0";
    }

    public String subtract() {
        calculatorfacade.sub(Double.parseDouble(currentInput));
        this.output = calculatorfacade.getOutput();
//    this.output="added";
        return "SubtractCal";
    }

    public String getCurrentInput() {
        return currentInput;
    }

    public void setCurrentInput(String currentInput) {
        this.currentInput = currentInput;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String goToAdd() {
        return "index";
    }
}
