/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.geronimo.samples.bank.ejb;

import java.util.List;

import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

@Remote(BankManagerFacadeRemote.class)
@Local(BankManagerFacadeLocal.class)
@Stateless
public class BankManagerFacadeBean implements BankManagerFacadeLocal {

    @PersistenceUnit(unitName = "BankPU")
    protected EntityManagerFactory emf;

    public BankManagerFacadeBean() {

    }

    public List<Account> getAccountInformation(String customerId) {
        EntityManager em = emf.createEntityManager();
        String query = "SELECT * FROM Account WHERE customerId='" + customerId + "'";
        List<Account> accountBeanList = (List<Account>) em.createNativeQuery(query, Account.class).getResultList();
        em.close();
        return accountBeanList;
    }

    public List<ExchangeRate> getExchangeRates() {
        EntityManager em = emf.createEntityManager();
        String query = "SELECT * FROM ExchangeRate";
        List<ExchangeRate> rateList = (List<ExchangeRate>) em.createNativeQuery(query, ExchangeRate.class).getResultList();
        em.close();
        return rateList;
    }

    public Customer getCustomer(String customerCode) {
        EntityManager em = emf.createEntityManager();

        Customer customer = (Customer) em.find(Customer.class, customerCode);
        em.close();
        return customer;
    }


    public void changeAccountBalance(String accountNo, Double balance) {
        EntityManager em = emf.createEntityManager();
        // get the Account
        Account account = (Account) em.find(Account.class, accountNo);

        // update the Account object
        account.setBalance(balance);
        em.persist(em);

        em.close();
    }

    public Double getAccountBalance(String accountNo) {
        EntityManager em = emf.createEntityManager();

        // get Account
        Account account = (Account) em.find(Account.class, accountNo);

        em.close();

        // return the balance as an object
        return new Double(account.getBalance());
    }
}
