/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.file;

import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class FileInfoAction
extends VfsActionSupport {
    @Argument(required=true)
    private String path;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject file = this.resolveFile(context, this.path);
        io.info("URL: {}", new Object[]{file.getURL()});
        io.info("Name: {}", new Object[]{file.getName()});
        io.info("BaseName: {}", new Object[]{file.getName().getBaseName()});
        io.info("Extension: {}", new Object[]{file.getName().getExtension()});
        io.info("Path: {}", new Object[]{file.getName().getPath()});
        io.info("Scheme: {}", new Object[]{file.getName().getScheme()});
        io.info("URI: {}", new Object[]{file.getName().getURI()});
        io.info("Root URI: {}", new Object[]{file.getName().getRootURI()});
        io.info("Parent: {}", new Object[]{file.getName().getParent()});
        io.info("Type: {}", new Object[]{file.getType()});
        io.info("Exists: {}", new Object[]{file.exists()});
        io.info("Readable: {}", new Object[]{file.isReadable()});
        io.info("Writeable: {}", new Object[]{file.isWriteable()});
        io.info("Root path: {}", new Object[]{file.getFileSystem().getRoot().getName().getPath()});
        if (file.exists()) {
            FileContent content = file.getContent();
            FileContentInfo contentInfo = content.getContentInfo();
            io.info("Content type: {}", new Object[]{contentInfo.getContentType()});
            io.info("Content encoding: {}", new Object[]{contentInfo.getContentEncoding()});
            try {
                Map attrs = content.getAttributes();
                if (attrs != null && !attrs.isEmpty()) {
                    io.info("Attributes:");
                    for (Map.Entry entry : attrs.entrySet()) {
                        io.info("    {}='{}'", new Object[]{entry.getKey(), entry.getValue()});
                    }
                }
            }
            catch (FileSystemException e) {
                io.info("File attributes are NOT supported");
            }
            try {
                Certificate[] certs = content.getCertificates();
                if (certs != null && certs.length != 0) {
                    io.info("Certificate:");
                    for (Certificate cert : certs) {
                        io.info("    {}", new Object[]{cert});
                    }
                }
            }
            catch (FileSystemException e) {
                io.info("File certificates are NOT supported");
            }
            if (file.getType().equals(FileType.FILE)) {
                io.info("Size: {} bytes", new Object[]{content.getSize()});
            } else if (file.getType().hasChildren() && file.isReadable()) {
                FileObject[] children = file.getChildren();
                io.info("Directory with {} files", new Object[]{children.length});
                for (int iterChildren = 0; iterChildren < children.length; ++iterChildren) {
                    io.info("#{}:{}", new Object[]{iterChildren, children[iterChildren].getName()});
                    if (iterChildren > 5) break;
                }
            }
            io.info("Last modified: {}", new Object[]{DateFormat.getInstance().format(new Date(content.getLastModifiedTime()))});
        } else {
            io.info("The file does not exist");
        }
        FileObjects.close((FileObject)file);
        return CommandAction.Result.SUCCESS;
    }
}

