/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.file;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.Selectors;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class CopyAction
extends VfsActionSupport {
    @Argument(index=0, required=true)
    private String sourcePath;
    @Argument(index=1, required=true)
    private String targetPath;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject source = this.resolveFile(context, this.sourcePath);
        FileObject target = this.resolveFile(context, this.targetPath);
        this.ensureFileExists(source);
        if (target.exists() && target.getType().hasChildren()) {
            target = target.resolveFile(source.getName().getBaseName());
        }
        this.log.info("Copying {} -> {}", (Object)source, (Object)target);
        target.copyFrom(source, Selectors.SELECT_ALL);
        FileObjects.closeAll((FileObject[])new FileObject[]{source, target});
        return CommandAction.Result.SUCCESS;
    }
}

