/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.util;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.samples.daytrader.util.TradeConfig;

public class Log {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(Log.class);

    public static void log(String message) {
        log.debug((Object)("DayTrader Log:" + new Date() + "------\n\t "));
        log.debug((Object)message);
    }

    public static void log(String msg1, String msg2) {
        Log.log(msg1 + msg2);
    }

    public static void log(String msg1, String msg2, String msg3) {
        Log.log(msg1 + msg2 + msg3);
    }

    public static void error(String message) {
        message = "Error: " + message;
        log.error((Object)message);
    }

    public static void error(String message, Throwable e) {
        Log.error(message + "\n\t" + e.toString());
        e.printStackTrace(System.out);
    }

    public static void error(String msg1, String msg2, Throwable e) {
        Log.error(msg1 + "\n" + msg2 + "\n\t", e);
    }

    public static void error(String msg1, String msg2, String msg3, Throwable e) {
        Log.error(msg1 + "\n" + msg2 + "\n" + msg3 + "\n\t", e);
    }

    public static void error(Throwable e, String message) {
        Log.error(message + "\n\t", e);
        e.printStackTrace(System.out);
    }

    public static void error(Throwable e, String msg1, String msg2) {
        Log.error(msg1 + "\n" + msg2 + "\n\t", e);
    }

    public static void error(Throwable e, String msg1, String msg2, String msg3) {
        Log.error(msg1 + "\n" + msg2 + "\n" + msg3 + "\n\t", e);
    }

    public static void trace(String message) {
        log.trace((Object)(message + " threadID=" + Thread.currentThread()));
    }

    public static void trace(String message, Object parm1) {
        Log.trace(message + "(" + parm1 + ")");
    }

    public static void trace(String message, Object parm1, Object parm2) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ")");
    }

    public static void trace(String message, Object parm1, Object parm2, Object parm3) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ", " + parm3 + ")");
    }

    public static void trace(String message, Object parm1, Object parm2, Object parm3, Object parm4) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ", " + parm3 + ")" + ", " + parm4);
    }

    public static void trace(String message, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ", " + parm3 + ")" + ", " + parm4 + ", " + parm5);
    }

    public static void trace(String message, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ", " + parm3 + ")" + ", " + parm4 + ", " + parm5 + ", " + parm6);
    }

    public static void trace(String message, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6, Object parm7) {
        Log.trace(message + "(" + parm1 + ", " + parm2 + ", " + parm3 + ")" + ", " + parm4 + ", " + parm5 + ", " + parm6 + ", " + parm7);
    }

    public static void traceEnter(String message) {
        log.trace((Object)("Method enter --" + message));
    }

    public static void traceExit(String message) {
        log.trace((Object)("Method exit  --" + message));
    }

    public static void stat(String message) {
        Log.log(message);
    }

    public static void debug(String message) {
        log.debug((Object)message);
    }

    public static void print(String message) {
        Log.log(message);
    }

    public static void printObject(Object o) {
        Log.log("\t" + o.toString());
    }

    public static void printCollection(Collection c) {
        Log.log("\t---Log.printCollection -- collection size=" + c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Log.log("\t\t" + it.next().toString());
        }
        Log.log("\t---Log.printCollection -- complete");
    }

    public static void printCollection(String message, Collection c) {
        Log.log(message);
        Log.printCollection(c);
    }

    public static boolean doActionTrace() {
        return Log.getTrace() || Log.getActionTrace();
    }

    public static boolean doTrace() {
        return Log.getTrace();
    }

    public static boolean doDebug() {
        return true;
    }

    public static boolean doStat() {
        return true;
    }

    public static boolean getTrace() {
        return TradeConfig.getTrace();
    }

    public static boolean getActionTrace() {
        return TradeConfig.getActionTrace();
    }

    public static void setTrace(boolean traceValue) {
        TradeConfig.setTrace(traceValue);
    }

    public static void setActionTrace(boolean traceValue) {
        TradeConfig.setActionTrace(traceValue);
    }
}

