/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.util;

import java.util.AbstractSequentialList;
import java.util.ListIterator;

public class KeyBlock
extends AbstractSequentialList {
    private int min = 0;
    private int max = 0;
    private int index = 0;

    public KeyBlock() {
        this.min = 0;
        this.max = 0;
        this.index = this.min;
    }

    public KeyBlock(int min, int max) {
        this.min = min;
        this.max = max;
        this.index = min;
    }

    public int size() {
        return this.max - this.min + 1;
    }

    public ListIterator listIterator(int arg0) {
        return new KeyBlockIterator();
    }

    class KeyBlockIterator
    implements ListIterator {
        KeyBlockIterator() {
        }

        public boolean hasNext() {
            return KeyBlock.this.index <= KeyBlock.this.max;
        }

        public synchronized Object next() {
            if (KeyBlock.this.index > KeyBlock.this.max) {
                throw new RuntimeException("KeyBlock:next() -- Error KeyBlock depleted");
            }
            return new Integer(KeyBlock.this.index++);
        }

        public boolean hasPrevious() {
            return KeyBlock.this.index > KeyBlock.this.min;
        }

        public Object previous() {
            return new Integer(--KeyBlock.this.index);
        }

        public int nextIndex() {
            return KeyBlock.this.index - KeyBlock.this.min;
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("KeyBlock: previousIndex() not supported");
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("KeyBlock: add() not supported");
        }

        public void remove() {
            throw new UnsupportedOperationException("KeyBlock: remove() not supported");
        }

        public void set(Object arg0) {
        }
    }
}

