/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
@Vetoed
public class LocalDateConverter
implements Converter<LocalDate> {
    public static final LocalDateConverter INSTANCE = new LocalDateConverter();

    public LocalDate convert(String value) {
        if (value != null) {
            try {
                return LocalDate.parse(value);
            }
            catch (DateTimeParseException dtpe) {
                throw new IllegalArgumentException(dtpe);
            }
        }
        return null;
    }
}

