/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
@Vetoed
public class InstantConverter
implements Converter<Instant> {
    public static final InstantConverter INSTANCE = new InstantConverter();

    public Instant convert(String value) {
        if (value != null) {
            try {
                return Instant.parse(value);
            }
            catch (DateTimeParseException dtpe) {
                throw new IllegalArgumentException(dtpe);
            }
        }
        return null;
    }
}

