/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.ConfigImpl;
import org.apache.geronimo.config.DefaultConfigProvider;
import org.apache.geronimo.config.configsource.BaseConfigSource;
import org.apache.geronimo.config.configsource.PropertyFileConfigSourceProvider;
import org.apache.geronimo.config.configsource.SystemEnvConfigSource;
import org.apache.geronimo.config.configsource.SystemPropertyConfigSource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
@Vetoed
public class DefaultConfigBuilder
implements ConfigBuilder {
    protected ClassLoader forClassLoader;
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private final List<Converter<?>> converters = new ArrayList();
    private boolean ignoreDefaultSources = true;
    private boolean ignoreDiscoveredSources = true;
    private boolean ignoreDiscoveredConverters = true;

    public ConfigBuilder addDefaultSources() {
        this.ignoreDefaultSources = false;
        return this;
    }

    public ConfigBuilder addDiscoveredSources() {
        this.ignoreDiscoveredSources = false;
        return this;
    }

    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.forClassLoader = loader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... sources) {
        this.sources.addAll(Arrays.asList(sources));
        return this;
    }

    public ConfigBuilder withConverters(Converter<?> ... converters) {
        this.converters.addAll(Arrays.asList(converters));
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        this.ignoreDiscoveredConverters = false;
        return this;
    }

    public Config build() {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        if (this.forClassLoader == null) {
            this.forClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.forClassLoader == null) {
                this.forClassLoader = DefaultConfigProvider.class.getClassLoader();
            }
        }
        if (!this.ignoreDefaultSources) {
            configSources.addAll(this.getBuiltInConfigSources(this.forClassLoader));
        }
        configSources.addAll(this.sources);
        if (!this.ignoreDiscoveredSources) {
            ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.forClassLoader);
            configSourceLoader.forEach(configSources::add);
            ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.forClassLoader);
            configSourceProviderLoader.forEach(configSourceProvider -> configSourceProvider.getConfigSources(this.forClassLoader).forEach(configSources::add));
        }
        if (!this.ignoreDiscoveredConverters) {
            ServiceLoader<Converter> converterLoader = ServiceLoader.load(Converter.class, this.forClassLoader);
            converterLoader.forEach(this.converters::add);
        }
        ConfigImpl config = new ConfigImpl();
        config.addConfigSources(configSources);
        for (Converter<?> converter : this.converters) {
            config.addConverter(converter);
        }
        return config;
    }

    protected Collection<? extends ConfigSource> getBuiltInConfigSources(ClassLoader forClassLoader) {
        ArrayList<BaseConfigSource> configSources = new ArrayList<BaseConfigSource>();
        configSources.add(new SystemEnvConfigSource());
        configSources.add(new SystemPropertyConfigSource());
        configSources.addAll((Collection<BaseConfigSource>)new PropertyFileConfigSourceProvider("/META-INF/microprofile-config.properties", true, forClassLoader).getConfigSources(forClassLoader));
        return configSources;
    }
}

