/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.testsuite.report;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.geronimo.mavenplugins.testsuite.report.SurefireReportGenerator;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class SurefireReportMojo
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private boolean showSuccess;
    private File reportsDirectory;
    private String outputName;
    private File xrefLocation;
    private boolean linkXRef;

    public void executeReport(Locale locale) throws MavenReportException {
        SurefireReportGenerator report = new SurefireReportGenerator(this.reportsDirectory, locale, this.showSuccess, this.determineXrefLocation());
        report.doGenerateReport(this.getBundle(locale), this.getSink());
        System.out.println("surefire-report.html generated.");
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory, (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                for (ReportPlugin report : this.project.getReportPlugins()) {
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.description");
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.outputName;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("surefire-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean canGenerateReport() {
        return "pom".equalsIgnoreCase(this.project.getPackaging());
    }
}

