/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.testsuite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.taskdefs.XmlProperty;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHExec;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.AntHelper;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class ResultsSummaryMojo
extends MojoSupport {
    protected AntHelper ant;
    private File targetDirectory;
    protected MavenProject project = null;
    protected Settings settings;
    private String username;
    private String password;
    private String passphrase;
    private String keyFile;
    private String buildNumber;
    private int numberShown;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private static final int PCENT = 100;
    private final String resultsFileName = "ResultsSummary.html";
    private Server server = null;
    private Scp scp;
    private SSHExec ssh;

    protected MavenProject getProject() {
        return this.project;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant.setProject(this.getProject());
        String siteId = this.project.getDistributionManagement().getSite().getId();
        this.server = this.settings.getServer(siteId);
        this.scp = (Scp)this.ant.createTask("scp");
        this.scp.setKeyfile(this.getKeyFile());
        this.scp.setPassword(this.getPassword());
        this.scp.setPassphrase(this.getPassphrase());
        this.scp.setTrust(true);
        this.ssh = (SSHExec)this.ant.createTask("sshexec");
        this.ssh.setKeyfile(this.getKeyFile());
        this.ssh.setPassword(this.getPassword());
        this.ssh.setPassphrase(this.getPassphrase());
        this.ssh.setTrust(true);
    }

    private String getKeyFile() {
        if (this.keyFile != null) {
            return this.keyFile;
        }
        if (this.server != null && this.server.getPrivateKey() != null) {
            return this.server.getPrivateKey();
        }
        return "/home/" + this.getUsername() + "/.ssh/id_dsa";
    }

    private String getUsername() {
        if (this.username != null) {
            return this.username;
        }
        if (this.server != null && this.server.getUsername() != null) {
            return this.server.getUsername();
        }
        return System.getProperty("user.name");
    }

    private String getPassword() {
        if (this.password != null) {
            return this.password;
        }
        if (this.server != null && this.server.getPassword() != null) {
            return this.server.getPassword();
        }
        return " ";
    }

    private String getPassphrase() {
        if (this.passphrase != null) {
            return this.passphrase;
        }
        if (this.server != null && this.server.getPassphrase() != null) {
            return this.server.getPassphrase();
        }
        return " ";
    }

    protected void doExecute() throws Exception {
        if (this.buildNumber == null) {
            this.log.warn((CharSequence)"No build number specified; returning");
            return;
        }
        File currentSiteDirectory = new File(this.targetDirectory, "/site");
        if (!currentSiteDirectory.exists()) {
            this.log.warn((CharSequence)"No site directory here; returning");
            return;
        }
        File resultsFile = null;
        try {
            this.downloadHTML();
            resultsFile = new File(this.targetDirectory, "ResultsSummary.html");
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("Download failed. " + e.getMessage()));
        }
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        if (resultsFile == null || !resultsFile.exists()) {
            this.log.info((CharSequence)"ResultsSummary.html could not be downloaded. Using the template to create anew");
            resultsFile = new File(this.project.getBasedir(), "src/main/resources/ResultsSummary.html");
        }
        FileInputStream is = new FileInputStream(resultsFile);
        Document document = tidy.parseDOM((InputStream)is, null);
        is.close();
        File reportsDir = new File(this.targetDirectory, "surefire-reports");
        if (!reportsDir.exists()) {
            this.log.warn((CharSequence)"No surefire-reports directory here");
            return;
        }
        ArrayList files = (ArrayList)FileUtils.getFiles((File)reportsDir, (String)"TEST-*.xml", null, (boolean)true);
        if (files.size() > 0 && (document = this.insertNewColumn(document)) == null) {
            throw new MojoFailureException("Main table cannot be found in the ResultsSummary.html. The file may be corrupted");
        }
        for (File file : files) {
            this.log.debug((CharSequence)("working on " + file.getAbsolutePath()));
            document = this.processFile(document, file);
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        File tempFile = new File(this.targetDirectory, "ResultsSummary-2.html");
        FileOutputStream os = new FileOutputStream(tempFile);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        os.flush();
        os.close();
        resultsFile = new File(this.targetDirectory, "ResultsSummary.html");
        is = new FileInputStream(tempFile);
        os = new FileOutputStream(resultsFile);
        tidy.parse((InputStream)is, (OutputStream)os);
        is.close();
        os.close();
        tempFile.delete();
        try {
            this.uploadHTML(resultsFile);
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("Upload failed. " + e.getMessage()));
        }
    }

    private String getRemoteUri() {
        String siteUri = this.project.getDistributionManagement().getSite().getUrl();
        int index = siteUri.indexOf("://");
        siteUri = siteUri.substring(index + 3);
        this.log.debug((CharSequence)("siteUri uri is " + siteUri));
        index = siteUri.lastIndexOf("/");
        siteUri = siteUri.substring(0, index);
        this.log.debug((CharSequence)("siteUri uri is " + siteUri));
        index = siteUri.indexOf("/");
        String remoteUri = siteUri.substring(0, index) + ":" + siteUri.substring(index);
        this.log.debug((CharSequence)("siteUri uri is " + remoteUri));
        remoteUri = this.getUsername() + ":" + this.getPassword() + "@" + remoteUri;
        this.log.info((CharSequence)("Remote uri is " + remoteUri));
        return remoteUri;
    }

    private void downloadHTML() {
        String remoteUri = this.getRemoteUri() + "/" + "ResultsSummary.html";
        this.scp.setFile(remoteUri);
        this.scp.setTodir(this.targetDirectory.getAbsolutePath());
        this.scp.execute();
    }

    private void uploadHTML(File resultsFile) {
        String remoteUri = this.getRemoteUri();
        this.scp.setFile(resultsFile.getAbsolutePath());
        this.scp.setTodir(remoteUri);
        this.scp.execute();
    }

    private Document insertNewColumn(Document document) {
        Element table = this.getElementById(document.getDocumentElement(), "table", "mainTable");
        if (table == null) {
            this.log.info((CharSequence)"table is null");
            return null;
        }
        Element thead = this.getElementById(table, "thead", "mainTableHead");
        Element tr = (Element)thead.getFirstChild();
        Element td = document.createElement("TD");
        td.setAttribute("class", "servers");
        Element anchor = document.createElement("a");
        anchor.setAttribute("href", "./" + this.buildNumber + "/surefire-report.html");
        Text text = document.createTextNode(this.buildNumber);
        anchor.appendChild(text);
        td.appendChild(anchor);
        tr.appendChild(td);
        int cols = tr.getChildNodes().getLength();
        if (cols > this.numberShown + 1) {
            cols = this.cleanup(table);
        }
        table.setAttribute("cols", String.valueOf(cols));
        return document;
    }

    private Document processFile(Document document, File file) {
        String pcent = this.getResultsFromFile(file);
        String fileName = FileUtils.basename((String)file.getName());
        fileName = fileName.substring(fileName.indexOf("-") + 1);
        fileName = fileName.substring(0, fileName.length() - 1);
        document = this.insertColumn(document, pcent, fileName);
        return document;
    }

    private String getResultsFromFile(File xmlFile) {
        String prefix = String.valueOf(System.currentTimeMillis());
        this.loadXMLProperty(xmlFile, prefix);
        String tests = this.ant.getAnt().getProperty(prefix + ".testsuite.tests");
        String errors = this.ant.getAnt().getProperty(prefix + ".testsuite.errors");
        String failures = this.ant.getAnt().getProperty(prefix + ".testsuite.failures");
        String skipped = this.ant.getAnt().getProperty(prefix + ".testsuite.skipped");
        this.log.debug((CharSequence)("tests: " + tests + "; errors:" + errors + "; failures:" + failures + "; skipped:" + skipped));
        int testsNum = Integer.parseInt(tests);
        int errorsNum = Integer.parseInt(errors);
        int failuresNum = Integer.parseInt(failures);
        int skippedNum = Integer.parseInt(skipped);
        String pcent = tests + "/" + errors + "/" + failures;
        return pcent;
    }

    private void loadXMLProperty(File src, String prefix) {
        XmlProperty xmlProperty = (XmlProperty)this.ant.createTask("xmlproperty");
        xmlProperty.setFile(src);
        if (prefix != null) {
            xmlProperty.setPrefix(prefix);
        }
        xmlProperty.setCollapseAttributes(true);
        xmlProperty.execute();
        this.log.debug((CharSequence)("Loaded xml file as ant property with prefix " + prefix));
    }

    public String computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests * 100.0f;
        return this.numberFormat.format(percentage);
    }

    private Document insertColumn(Document document, String pcent, String suiteName) {
        this.log.debug((CharSequence)"inserting column");
        Element table = this.getElementById(document.getDocumentElement(), "table", "mainTable");
        int cols = Integer.parseInt(table.getAttribute("cols"));
        Element tr = this.getElementById(table, "tr", suiteName);
        if (tr != null) {
            Element td;
            NodeList nodeList = tr.getElementsByTagName("td");
            for (int i = nodeList.getLength() + 1; i < cols; ++i) {
                td = document.createElement("TD");
                td.setAttribute("class", "cell");
                tr.appendChild(td);
            }
            td = document.createElement("TD");
            td.setAttribute("class", "cell");
            Element anchor = document.createElement("a");
            anchor.setAttribute("href", "./" + this.buildNumber + "/" + suiteName + "/surefire-report.html");
            Text text = document.createTextNode(pcent);
            anchor.appendChild(text);
            td.appendChild(anchor);
            tr.appendChild(td);
        } else {
            this.log.debug((CharSequence)"Creating a new row for a new suite");
            tr = document.createElement("TR");
            tr.setAttribute("id", suiteName);
            Element td = document.createElement("TD");
            td.setAttribute("class", "suite");
            Text text = document.createTextNode(suiteName);
            td.appendChild(text);
            tr.appendChild(td);
            for (int i = 1; i < cols; ++i) {
                td = document.createElement("TD");
                td.setAttribute("class", "cell");
                tr.appendChild(td);
            }
            Element anchor = document.createElement("a");
            anchor.setAttribute("href", "./" + this.buildNumber + "/" + suiteName + "/surefire-report.html");
            text = document.createTextNode(pcent);
            anchor.appendChild(text);
            td.appendChild(anchor);
            table.appendChild(tr);
        }
        this.log.debug((CharSequence)"inserted column");
        return document;
    }

    private Element getElementById(Element element, String tagName, String id) {
        this.log.debug((CharSequence)("Searching for tag " + tagName + " with id=" + id));
        Element foundElement = null;
        NodeList nodeList = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            foundElement = (Element)nodeList.item(i);
            this.log.debug((CharSequence)("Element is " + foundElement.getTagName() + " " + foundElement.getAttribute("id")));
            if (id.trim().equals(foundElement.getAttribute("id").trim())) break;
            foundElement = null;
        }
        return foundElement;
    }

    private int cleanup(Element table) {
        this.log.info((CharSequence)"Removing oldest column");
        NodeList nodeList = table.getElementsByTagName("tr");
        int new_cols = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element tr = (Element)nodeList.item(i);
            Element suiteColumn = (Element)tr.getFirstChild();
            Element removeMe = (Element)suiteColumn.getNextSibling();
            tr.removeChild(removeMe);
            if (i != 0) continue;
            new_cols = tr.getChildNodes().getLength();
        }
        if (new_cols > this.numberShown + 1) {
            new_cols = this.cleanup(table);
        }
        this.log.debug((CharSequence)String.valueOf("Returning cols: " + new_cols));
        return new_cols;
    }
}

