/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.testsuite.report;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.mavenplugins.testsuite.report.ReportTestCase;
import org.apache.geronimo.mavenplugins.testsuite.report.ReportTestSuite;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.SAXException;

public class SurefireReportParser {
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private File reportsDirectory;
    private List testSuites = new ArrayList();
    private Locale locale;
    private static final int PCENT = 100;

    public SurefireReportParser() {
    }

    public SurefireReportParser(File reportsDirectory, Locale locale) {
        this.reportsDirectory = reportsDirectory;
        this.setLocale(locale);
    }

    public List parseXMLReportFiles() throws MavenReportException {
        if (this.reportsDirectory.exists()) {
            String[] xmlReportFiles = this.getIncludedFiles(this.reportsDirectory, "*.xml", "*.txt");
            for (int index = 0; index < xmlReportFiles.length; ++index) {
                ReportTestSuite testSuite = new ReportTestSuite();
                String currentReport = xmlReportFiles[index];
                try {
                    testSuite.parse(this.reportsDirectory + "/" + currentReport);
                }
                catch (ParserConfigurationException e) {
                    throw new MavenReportException("Error setting up parser for JUnit XML report", (Exception)e);
                }
                catch (SAXException e) {
                    throw new MavenReportException("Error parsing JUnit XML report " + currentReport, (Exception)e);
                }
                catch (IOException e) {
                    throw new MavenReportException("Error reading JUnit XML report " + currentReport, (Exception)e);
                }
                this.testSuites.add(testSuite);
            }
        }
        return this.testSuites;
    }

    protected String parseTestSuiteName(String lineString) {
        return lineString.substring(lineString.lastIndexOf(".") + 1, lineString.length());
    }

    protected String parseTestSuitePackageName(String lineString) {
        return lineString.substring(lineString.indexOf(":") + 2, lineString.lastIndexOf("."));
    }

    protected String parseTestCaseName(String lineString) {
        return lineString.substring(0, lineString.indexOf("("));
    }

    public Map getSummary(List suites) {
        HashMap<String, String> totalSummary = new HashMap<String, String>();
        ListIterator iter = suites.listIterator();
        int totalNumberOfTests = 0;
        int totalNumberOfErrors = 0;
        int totalNumberOfFailures = 0;
        int totalNumberOfSkipped = 0;
        float totalElapsedTime = 0.0f;
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            totalNumberOfTests += suite.getNumberOfTests();
            totalNumberOfErrors += suite.getNumberOfErrors();
            totalNumberOfFailures += suite.getNumberOfFailures();
            totalNumberOfSkipped += suite.getNumberOfSkipped();
            totalElapsedTime += suite.getTimeElapsed();
        }
        String totalPercentage = this.computePercentage(totalNumberOfTests, totalNumberOfErrors, totalNumberOfFailures, totalNumberOfSkipped);
        totalSummary.put("totalTests", Integer.toString(totalNumberOfTests));
        totalSummary.put("totalErrors", Integer.toString(totalNumberOfErrors));
        totalSummary.put("totalFailures", Integer.toString(totalNumberOfFailures));
        totalSummary.put("totalSkipped", Integer.toString(totalNumberOfSkipped));
        totalSummary.put("totalElapsedTime", this.numberFormat.format(totalElapsedTime));
        totalSummary.put("totalPercentage", totalPercentage);
        return totalSummary;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Map getSuitesGroupByPackage(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        HashMap suitePackage = new HashMap();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List<ReportTestSuite> suiteList = new ArrayList<ReportTestSuite>();
            if (suitePackage.get(suite.getPackageName()) != null) {
                suiteList = (List)suitePackage.get(suite.getPackageName());
            }
            suiteList.add(suite);
            suitePackage.put(suite.getPackageName(), suiteList);
        }
        return suitePackage;
    }

    public String computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests * 100.0f;
        return this.numberFormat.format(percentage);
    }

    public List getFailureDetails(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        ArrayList<ReportTestCase> failureDetailList = new ArrayList<ReportTestCase>();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List testCaseList = suite.getTestCases();
            if (testCaseList == null) continue;
            ListIterator caseIter = testCaseList.listIterator();
            while (caseIter.hasNext()) {
                ReportTestCase tCase = (ReportTestCase)caseIter.next();
                if (tCase.getFailure() == null) continue;
                failureDetailList.add(tCase);
            }
        }
        return failureDetailList;
    }

    private String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

