/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.testsuite.report;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.geronimo.mavenplugins.testsuite.report.ReportTestCase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportTestSuite
extends DefaultHandler {
    private List testCases;
    private int numberOfErrors;
    private int numberOfFailures;
    private int numberOfSkipped;
    private int numberOfTests;
    private String name;
    private String fullClassName;
    private String packageName;
    private float timeElapsed;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private StringBuilder currentElement;
    private ReportTestCase testCase;

    public void parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(new File(xmlPath), (DefaultHandler)this);
    }

    private int getAttributeAsInt(Attributes attributes, String name) {
        String valueAsString = attributes.getValue(name);
        if (valueAsString != null) {
            return Integer.parseInt(valueAsString);
        }
        return 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("testsuite".equals(qName)) {
                this.numberOfErrors = this.getAttributeAsInt(attributes, "errors");
                this.numberOfFailures = this.getAttributeAsInt(attributes, "failures");
                this.numberOfSkipped = this.getAttributeAsInt(attributes, "skipped");
                this.numberOfTests = this.getAttributeAsInt(attributes, "tests");
                Number time = this.numberFormat.parse(attributes.getValue("time"));
                this.timeElapsed = time.floatValue();
                if (attributes.getValue("group") != null && !"".equals(attributes.getValue("group"))) {
                    this.packageName = attributes.getValue("group");
                    this.name = attributes.getValue("name");
                    this.fullClassName = this.packageName + "." + this.name;
                } else {
                    this.fullClassName = attributes.getValue("name");
                    this.name = this.fullClassName.substring(this.fullClassName.lastIndexOf(".") + 1, this.fullClassName.length());
                    int lastDotPosition = this.fullClassName.lastIndexOf(".");
                    this.packageName = lastDotPosition < 0 ? "" : this.fullClassName.substring(0, lastDotPosition);
                }
                this.testCases = new ArrayList();
            } else if ("testcase".equals(qName)) {
                this.currentElement = new StringBuilder();
                this.testCase = new ReportTestCase();
                this.testCase.setFullClassName(this.fullClassName);
                this.testCase.setName(attributes.getValue("name"));
                this.testCase.setClassName(this.name);
                String timeAsString = attributes.getValue("time");
                Number time = new Integer(0);
                if (timeAsString != null) {
                    time = this.numberFormat.parse(timeAsString);
                }
                this.testCase.setTime(((Number)time).floatValue());
                this.testCase.setFullName(this.packageName + "." + this.name + "." + this.testCase.getName());
            } else if ("failure".equals(qName)) {
                this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
            } else if ("error".equals(qName)) {
                this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
            }
        }
        catch (ParseException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("testcase".equals(qName)) {
            this.testCases.add(this.testCase);
        } else if ("failure".equals(qName)) {
            Map failure = this.testCase.getFailure();
            failure.put("detail", this.parseCause(this.currentElement.toString()));
        } else if ("error".equals(qName)) {
            Map error = this.testCase.getFailure();
            error.put("detail", this.parseCause(this.currentElement.toString()));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (!"".equals(s.trim())) {
            this.currentElement.append(s);
        }
    }

    public List getTestCases() {
        return this.testCases;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public void setNumberOfFailures(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
    }

    public int getNumberOfSkipped() {
        return this.numberOfSkipped;
    }

    public void setNumberOfSkipped(int numberOfSkipped) {
        this.numberOfSkipped = numberOfSkipped;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public void setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFName() {
        return this.name;
    }

    public void setFName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public float getTimeElapsed() {
        return this.timeElapsed;
    }

    public void setTimeElapsed(float timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    private List parseCause(String detail) {
        String fullName = this.testCase.getFullName();
        String name = fullName.substring(fullName.lastIndexOf(".") + 1);
        return this.parseCause(detail, name);
    }

    private List parseCause(String detail, String compareTo) {
        StringTokenizer stringTokenizer = new StringTokenizer(detail, "\n");
        ArrayList<String> parsedDetail = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String lineString = stringTokenizer.nextToken().trim();
            parsedDetail.add(lineString);
            if (lineString.indexOf(compareTo) < 0) continue;
            break;
        }
        return parsedDetail;
    }

    public void setTestCases(List testCases) {
        this.testCases = Collections.unmodifiableList(testCases);
    }
}

