/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.testsuite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.taskdefs.XmlProperty;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.AntHelper;
import org.codehaus.plexus.util.FileUtils;

public class SurefireXMLGeneratorMojo
extends MojoSupport {
    protected AntHelper ant;
    private File currentBuildDirectory;
    private File currentReportsDirectory;
    private File currentBaseDirectory;
    private File parentBuildDirectory;
    private File parentReportsDirectory;
    private boolean grandParent;
    protected MavenProject project = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant.setProject(this.getProject());
        this.currentReportsDirectory = new File(this.currentBuildDirectory, "surefire-reports");
        if (this.grandParent) {
            this.log.debug((CharSequence)(this.getProject().getParent().getParent().getArtifactId() + " -- " + this.getProject().getParent().getParent().getBasedir().getAbsolutePath()));
            this.parentBuildDirectory = new File(this.getProject().getParent().getParent().getBasedir(), "target");
        }
        this.parentReportsDirectory = new File(this.parentBuildDirectory, "surefire-reports");
        this.log.info((CharSequence)("Updating directory: " + this.parentReportsDirectory.getAbsolutePath()));
    }

    protected void doExecute() throws Exception {
        File parentSurefireXMLFile;
        if (!this.currentReportsDirectory.exists()) {
            this.log.info((CharSequence)"No surefire-reports directory here");
            return;
        }
        String parent_tests = "0";
        String parent_skipped = "0";
        String parent_errors = "0";
        String parent_failures = "0";
        String parent_time = "0";
        String artifactName = FileUtils.filename((String)this.currentBaseDirectory.getAbsolutePath());
        if (!this.parentReportsDirectory.exists()) {
            this.parentReportsDirectory.mkdirs();
        }
        if ((parentSurefireXMLFile = new File(this.parentReportsDirectory, "TEST-" + artifactName + ".xml")).exists()) {
            parentSurefireXMLFile.delete();
        }
        if (this.grandParent) {
            artifactName = this.project.getParent().getBasedir().getName() + "@" + artifactName;
        }
        ArrayList xmlFiles = (ArrayList)FileUtils.getFiles((File)this.currentReportsDirectory, (String)"TEST*.xml", null);
        for (int i = 0; i < xmlFiles.size(); ++i) {
            File xmlFile = (File)xmlFiles.get(i);
            this.log.info((CharSequence)("Loading surefire xml for xmlproperty: " + xmlFile.getAbsolutePath()));
            String prefix = String.valueOf(System.currentTimeMillis());
            this.loadXMLProperty(xmlFile, prefix);
            String tests = this.ant.getAnt().getProperty(prefix + ".testsuite.tests");
            String skipped = this.ant.getAnt().getProperty(prefix + ".testsuite.skipped");
            String errors = this.ant.getAnt().getProperty(prefix + ".testsuite.errors");
            String failures = this.ant.getAnt().getProperty(prefix + ".testsuite.failures");
            String time = this.ant.getAnt().getProperty(prefix + ".testsuite.time");
            this.log.debug((CharSequence)("tests=" + tests + "; skipped=" + skipped + ", errors=" + errors + ", failures=" + failures + ", time=" + time));
            if (parentSurefireXMLFile.exists()) {
                this.log.info((CharSequence)("Loading parent surefire xml for xmlproperty: " + parentSurefireXMLFile.getAbsolutePath()));
                String parentPrefix = "parent" + prefix;
                this.loadXMLProperty(parentSurefireXMLFile, parentPrefix);
                parent_tests = this.ant.getAnt().getProperty(parentPrefix + ".testsuite.tests");
                parent_skipped = this.ant.getAnt().getProperty(parentPrefix + ".testsuite.skipped");
                parent_errors = this.ant.getAnt().getProperty(parentPrefix + ".testsuite.errors");
                parent_failures = this.ant.getAnt().getProperty(parentPrefix + ".testsuite.failures");
                parent_time = this.ant.getAnt().getProperty(parentPrefix + ".testsuite.time");
                this.log.debug((CharSequence)("tests=" + parent_tests + "; skipped=" + parent_skipped + ", errors=" + parent_errors + ", failures=" + parent_failures + ", time=" + parent_time));
            }
            int testsNum = Integer.parseInt(parent_tests) + Integer.parseInt(tests);
            int skippedNum = Integer.parseInt(parent_skipped) + Integer.parseInt(skipped);
            int errorsNum = Integer.parseInt(parent_errors) + Integer.parseInt(errors);
            int failuresNum = Integer.parseInt(parent_failures) + Integer.parseInt(failures);
            float timeNum = this.getTime(parent_time) + this.getTime(time);
            this.writeParentXML(testsNum, skippedNum, errorsNum, failuresNum, timeNum, artifactName, parentSurefireXMLFile);
        }
    }

    private float getTime(String time) {
        time = time.replaceAll(",", "");
        return Float.parseFloat(time);
    }

    private void loadXMLProperty(File src, String prefix) {
        XmlProperty xmlProperty = (XmlProperty)this.ant.createTask("xmlproperty");
        xmlProperty.setFile(src);
        if (prefix != null) {
            xmlProperty.setPrefix(prefix);
        }
        xmlProperty.setCollapseAttributes(true);
        xmlProperty.execute();
    }

    private void writeParentXML(int testsNum, int skippedNum, int errorsNum, int failuresNum, float timeNum, String artifactName, File parentSurefireXMLFile) throws IOException {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        String testSuite = "<testsuite errors=\"" + errorsNum + "\" skipped=\"" + skippedNum + "\" tests=\"" + testsNum + "\" time=\"" + timeNum + "\" failures=\"" + failuresNum + "\" name=\"" + artifactName + "#.\"/>";
        String parentSurefireXMLFileName = parentSurefireXMLFile.getAbsolutePath();
        this.log.debug((CharSequence)testSuite);
        FileUtils.fileWrite((String)parentSurefireXMLFileName, (String)("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n" + testSuite));
    }
}

