/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.osgi.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.geronimo.mavenplugins.osgi.utils.BundleUtil;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleResolver {
    private static final String PROP_MAVEN_PROJECT = "MavenProject";
    private static final String PROP_MANIFEST = "BundleManifest";
    private StateObjectFactory factory = StateObjectFactory.defaultFactory;
    private State state;
    private long id = 0L;
    private Logger logger;

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        BundleDescription[] imported = BundleResolver.getImportedBundles(root);
        BundleDescription[] required = BundleResolver.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (root.getLocation().equals(packages[i].getExporter().getLocation()) || resolvedImports.contains(packages[i].getExporter())) continue;
            resolvedImports.add(packages[i].getExporter());
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public BundleResolver(Logger logger) {
        this.logger = logger;
        this.state = this.factory.createState(true);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        BundleUtil.loadVMProfile(props);
        this.state.setPlatformProperties((Dictionary)props);
        URL url = Bundle.class.getProtectionDomain().getCodeSource().getLocation();
        File osgi = BundleResolver.toFile(url);
        try {
            this.addBundle(osgi);
        }
        catch (BundleException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private long getNextId() {
        return ++this.id;
    }

    public BundleDescription addBundle(File bundleLocation) throws BundleException {
        return this.addBundle(bundleLocation, false);
    }

    public BundleDescription addBundle(File bundleLocation, boolean override) throws BundleException {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        Dictionary manifest = this.loadManifestAttributes(bundleLocation);
        if (manifest == null) {
            throw new BundleException("Manifest not found in " + bundleLocation);
        }
        return this.addBundle(manifest, bundleLocation, override);
    }

    public BundleDescription addBundle(File manifestLocation, File bundleLocation, boolean override) throws BundleException {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        Dictionary manifest = this.loadManifestAttributes(manifestLocation);
        if (manifest == null) {
            throw new IllegalArgumentException("Manifest not found in " + manifestLocation);
        }
        return this.addBundle(manifest, bundleLocation, override);
    }

    private Dictionary loadManifestAttributes(File bundleLocation) {
        Manifest m = this.loadManifest(bundleLocation);
        if (m == null) {
            return null;
        }
        return this.manifestToProperties(m.getMainAttributes());
    }

    public Manifest loadManifest(File bundleLocation) {
        try {
            return BundleUtil.getManifest(bundleLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    private BundleDescription addBundle(Dictionary enhancedManifest, File bundleLocation, boolean override) throws BundleException {
        BundleDescription[] conflicts;
        BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
        BundleResolver.setUserProperty(descriptor, PROP_MANIFEST, enhancedManifest);
        if (override && (conflicts = this.state.getBundles(descriptor.getSymbolicName())) != null) {
            for (BundleDescription conflict : conflicts) {
                this.state.removeBundle(conflict);
                this.logger.warn(conflict.toString() + " has been replaced by another bundle with the same symbolic name " + descriptor.toString());
            }
        }
        this.state.addBundle(descriptor);
        return descriptor;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.state.getBundles(bundleId);
        if (description == null) {
            return null;
        }
        for (int i = 0; i < description.length; ++i) {
            if (!description[i].isResolved()) continue;
            return description[i];
        }
        return null;
    }

    public void resolveState() {
        this.state.resolve(false);
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Resolved OSGi state\n");
            for (BundleDescription bundle : this.state.getBundles()) {
                if (!bundle.isResolved()) {
                    sb.append("[X] ");
                } else {
                    sb.append("[V] ");
                }
                sb.append(bundle).append(": (").append(bundle.getLocation());
                sb.append(")\n");
                for (ResolverError error : this.state.getResolverErrors(bundle)) {
                    sb.append("    ").append(error.toString()).append('\n');
                }
            }
            this.logger.debug(sb.toString());
        }
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getBundles() {
        return this.state.getBundles();
    }

    public ResolverError[] getResolverErrors(BundleDescription bundle) {
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        this.getRelevantErrors(errors, bundle);
        return errors.toArray(new ResolverError[errors.size()]);
    }

    private void getRelevantErrors(Set<ResolverError> errors, BundleDescription bundle) {
        ResolverError[] bundleErrors = this.state.getResolverErrors(bundle);
        for (int j = 0; j < bundleErrors.length; ++j) {
            ResolverError error = bundleErrors[j];
            errors.add(error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (!(constraint instanceof BundleSpecification) && !(constraint instanceof HostSpecification)) continue;
            BundleDescription[] requiredBundles = this.state.getBundles(constraint.getName());
            for (int i = 0; i < requiredBundles.length; ++i) {
                this.getRelevantErrors(errors, requiredBundles[i]);
            }
        }
    }

    private void logError(BundleDescription bundle, int level, Object object) {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            msg.append("--");
        }
        msg.append("> [").append(bundle.getSymbolicName()).append("] ");
        msg.append(object);
        this.logger.error(msg.toString());
    }

    public void analyzeErrors(BundleDescription bundle) {
        this.analyzeErrors(bundle, new HashSet<BundleDescription>(), 1);
    }

    private void analyzeErrors(BundleDescription bundle, Set<BundleDescription> bundles, int level) {
        ResolverError[] errors;
        if (bundles.contains(bundle)) {
            return;
        }
        bundles.add(bundle);
        block5: for (ResolverError error : errors = this.state.getResolverErrors(bundle)) {
            this.logError(bundle, level, error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            switch (error.getType()) {
                case 1: {
                    ImportPackageSpecification pkgSpec = (ImportPackageSpecification)constraint;
                    for (BundleDescription b : this.getBundles()) {
                        for (ExportPackageDescription pkg : b.getExportPackages()) {
                            if (!pkg.getName().equals(pkgSpec.getName())) continue;
                            if (pkgSpec.getVersionRange().isIncluded(pkg.getVersion())) {
                                if (pkg.getExporter().isResolved()) continue;
                                this.logError(b, level, "Bundle unresolved: " + pkg);
                                this.analyzeErrors(pkg.getExporter(), bundles, level + 1);
                                continue;
                            }
                            this.logError(b, level, "Version mismatch: " + pkgSpec + " " + pkg);
                        }
                    }
                    continue block5;
                }
                case 2: 
                case 4: {
                    for (BundleDescription b : this.getBundles()) {
                        if (b == bundle) continue;
                        if (b.getSymbolicName() == null) {
                            this.logError(b, level, "No SymbolicName for " + b.getLocation());
                            continue;
                        }
                        if (constraint.getName() == null) {
                            this.logError(bundle, level, "no constraint name: " + constraint);
                        }
                        if (!b.getSymbolicName().equals(constraint.getName())) continue;
                        if (constraint.getVersionRange().isIncluded(b.getVersion())) {
                            this.analyzeErrors(b, bundles, level);
                            continue;
                        }
                        this.logError(bundle, level, "Version mismatch: " + constraint + " " + b);
                    }
                    continue block5;
                }
                case 32: {
                    ImportPackageSpecification importPackage = (ImportPackageSpecification)constraint;
                    for (BundleDescription b : this.getBundles()) {
                        for (ExportPackageDescription pkg : b.getExportPackages()) {
                            if (!pkg.getName().equals(importPackage.getName())) continue;
                            this.logError(pkg.getExporter(), level + 1, pkg.toString());
                        }
                    }
                    continue block5;
                }
            }
        }
    }

    public Set<ResolverError> getAllErrors() {
        BundleDescription[] bundles = this.state.getBundles();
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        for (int i = 0; i < bundles.length; ++i) {
            BundleDescription bundle = bundles[i];
            ResolverError[] bundleErrors = this.state.getResolverErrors(bundle);
            if (bundleErrors == null) continue;
            errors.addAll(Arrays.asList(bundleErrors));
        }
        return errors;
    }

    public List<BundleDescription> getDependencies(BundleDescription desc) {
        LinkedHashSet<Long> bundleIds = new LinkedHashSet<Long>();
        BundleResolver.addBundleAndDependencies(desc, bundleIds, true);
        ArrayList<BundleDescription> dependencies = new ArrayList<BundleDescription>();
        Iterator i$ = bundleIds.iterator();
        while (i$.hasNext()) {
            BundleDescription dependency;
            BundleDescription supplier;
            HostSpecification host;
            long bundleId = (Long)i$.next();
            if (desc.getBundleId() == bundleId || (host = (supplier = (dependency = this.state.getBundle(bundleId)).getSupplier().getSupplier()).getHost()) != null && desc.equals(host.getSupplier())) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static void addBundleAndDependencies(BundleDescription desc, Set<Long> bundleIds, boolean includeOptional) {
        if (desc != null && bundleIds.add(new Long(desc.getBundleId()))) {
            BundleSpecification[] required = desc.getRequiredBundles();
            for (int i = 0; i < required.length; ++i) {
                if (!includeOptional && required[i].isOptional()) continue;
                BundleResolver.addBundleAndDependencies((BundleDescription)required[i].getSupplier(), bundleIds, includeOptional);
            }
            ImportPackageSpecification[] importedPkgs = desc.getImportPackages();
            for (int i = 0; i < importedPkgs.length; ++i) {
                ExportPackageDescription exporter = (ExportPackageDescription)importedPkgs[i].getSupplier();
                if (exporter == null || !includeOptional && "optional".equals(importedPkgs[i].getDirective("resolution"))) continue;
                BundleResolver.addBundleAndDependencies(exporter.getExporter(), bundleIds, includeOptional);
            }
            BundleDescription[] fragments = desc.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                String id;
                if (!fragments[i].isResolved() || "org.eclipse.ui.workbench.compatibility".equals(id = fragments[i].getSymbolicName())) continue;
                BundleResolver.addBundleAndDependencies(fragments[i], bundleIds, includeOptional);
            }
            HostSpecification host = desc.getHost();
            if (host != null) {
                BundleResolver.addBundleAndDependencies((BundleDescription)host.getSupplier(), bundleIds, includeOptional);
            }
        }
    }

    public BundleDescription getBundleDescription(MavenProject project) {
        String location = project.getFile().getParentFile().getAbsolutePath();
        return this.state.getBundleByLocation(location);
    }

    public BundleDescription getBundleDescription(File location) {
        String absolutePath = location.getAbsolutePath();
        return this.state.getBundleByLocation(absolutePath);
    }

    private static void setUserProperty(BundleDescription desc, String name, Object value) {
        Object userObject = desc.getUserObject();
        if (userObject != null && !(userObject instanceof Map)) {
            throw new IllegalStateException("Unexpected user object " + desc.toString());
        }
        HashMap<String, Object> props = (HashMap<String, Object>)userObject;
        if (props == null) {
            props = new HashMap<String, Object>();
            desc.setUserObject(props);
        }
        props.put(name, value);
    }

    private static Object getUserProperty(BundleDescription desc, String name) {
        Object userObject = desc.getUserObject();
        if (userObject instanceof Map) {
            return ((Map)userObject).get(name);
        }
        return null;
    }

    public MavenProject getMavenProject(BundleDescription desc) {
        return (MavenProject)BundleResolver.getUserProperty(desc, PROP_MAVEN_PROJECT);
    }

    public void assertResolved(BundleDescription desc) throws BundleException {
        if (!desc.isResolved()) {
            throw new BundleException("Bundle cannot be resolved: " + desc);
        }
    }

    public String reportErrors(BundleDescription desc) {
        StringBuffer msg = new StringBuffer();
        msg.append("Bundle ").append(desc.getSymbolicName()).append(" cannot be resolved: \n");
        BundleDescription[] bundles = this.state.getBundles();
        int index = 0;
        for (BundleDescription b : bundles) {
            if (b.isResolved()) continue;
            ResolverError[] errors = this.state.getResolverErrors(b);
            if (errors.length > 0) {
                msg.append("  ").append("[").append(index++).append("] ").append(b.getSymbolicName()).append("\n");
            }
            for (int i = 0; i < errors.length; ++i) {
                ResolverError error = errors[i];
                msg.append("  -->").append(error).append("\n");
            }
        }
        return msg.toString();
    }

    public String getManifestAttribute(BundleDescription desc, String attr) {
        Dictionary mf = (Dictionary)BundleResolver.getUserProperty(desc, PROP_MANIFEST);
        if (mf != null) {
            return (String)mf.get(attr);
        }
        return null;
    }

    private static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar).replace("%20", " ");
        return new File(filename);
    }
}

