/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.osgi;

import java.io.File;
import java.util.List;
import org.apache.geronimo.mavenplugins.osgi.utils.BundleResolver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;

public class VerifyManifestMojo
extends AbstractLogEnabled
implements Mojo {
    private Log log;
    protected MavenProject project;
    protected File targetDir = null;
    protected String profileName = null;
    protected boolean failOnError = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block11: {
            List classpath;
            File manifest = new File(this.targetDir, "META-INF/MANIFEST.MF");
            if (!manifest.exists()) {
                return;
            }
            if (this.profileName != null) {
                System.setProperty("osgi.java.profile", this.profileName);
            }
            BundleResolver stateController = new BundleResolver(this.getLogger());
            try {
                classpath = this.project.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            for (String path : classpath) {
                try {
                    File cp = new File(path);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("Adding bundle: " + cp));
                    }
                    if (!cp.exists()) continue;
                    stateController.addBundle(cp);
                }
                catch (BundleException e) {
                    this.log.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            stateController.resolveState();
            BundleDescription b = stateController.getBundleDescription(this.targetDir);
            if (b != null) {
                this.log.info((CharSequence)("Resolving OSGi bundle: " + b.getSymbolicName()));
                try {
                    stateController.assertResolved(b);
                    this.log.info((CharSequence)("OSGi bundle is resolved: " + b.getSymbolicName()));
                }
                catch (BundleException e) {
                    stateController.analyzeErrors(b);
                    if (!this.failOnError) break block11;
                    throw new MojoExecutionException("OSGi bundle resolution failed");
                }
            }
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }
}

