/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.osgi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.mavenplugins.osgi.utils.BundleResolver;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.osgi.framework.BundleException;

public class DisplayManifestMojo
extends AbstractLogEnabled
implements Mojo {
    private final String TAB = "  ";
    private Log log;
    protected MavenProject project;
    protected File target = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.target.exists()) {
            return;
        }
        BundleResolver stateController = new BundleResolver(this.getLogger());
        try {
            stateController.addBundle(this.target);
        }
        catch (BundleException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        stateController.resolveState();
        BundleDescription b = stateController.getBundleDescription(this.target);
        if (b != null) {
            this.displayManifest(b);
        }
    }

    private void displayManifest(BundleDescription b) {
        System.out.println("Bundle: " + b.getSymbolicName());
        this.displayImports(b, "static", "Imports:");
        this.displayImports(b, "optional", "Optional Imports:");
        this.displayImports(b, "dynamic", "Dynamic Imports:");
        this.displayExports(b);
        this.displayRequiredBundles(b);
        this.displayFragments(b);
    }

    private void displayExports(BundleDescription b) {
        ExportPackageDescription[] exportPackages = b.getExportPackages();
        if (exportPackages != null && exportPackages.length > 0) {
            System.out.println("Exports:");
            for (ExportPackageDescription exportPackage : exportPackages) {
                Map directives;
                StringBuffer buf = new StringBuffer();
                buf.append("  " + exportPackage);
                Map attributes = exportPackage.getAttributes();
                if (attributes != null) {
                    attributes.remove("version");
                    if (!attributes.isEmpty()) {
                        buf.append(" Attributes: ").append(attributes);
                    }
                }
                if ((directives = exportPackage.getDirectives()) != null) {
                    directives.remove("uses");
                    directives.remove("x-equinox-ee");
                    directives.remove("x-internal");
                    if (!directives.isEmpty()) {
                        buf.append(" Directives: ").append(directives);
                    }
                }
                System.out.println(buf);
                String[] list = (String[])exportPackage.getDirective("uses");
                if (list == null) continue;
                System.out.println("    Uses: " + Arrays.asList(list));
            }
            System.out.println();
        }
    }

    private void displayImports(BundleDescription b, String resolution, String header) {
        List<ImportPackageSpecification> imports = this.getImports(b, resolution);
        if (!imports.isEmpty()) {
            System.out.println(header);
            for (ImportPackageSpecification importPackage : imports) {
                Map directives;
                StringBuffer buf = new StringBuffer();
                buf.append("  " + importPackage);
                Map attributes = importPackage.getAttributes();
                if (attributes != null) {
                    attributes.remove("version");
                    if (!attributes.isEmpty()) {
                        buf.append(" Attributes: ").append(attributes);
                    }
                }
                if ((directives = importPackage.getDirectives()) != null) {
                    directives.remove("resolution");
                    if (!directives.isEmpty()) {
                        buf.append(" Directives: ").append(directives);
                    }
                }
                System.out.println(buf);
            }
            System.out.println();
        }
    }

    private List<ImportPackageSpecification> getImports(BundleDescription b, String resolution) {
        ArrayList<ImportPackageSpecification> imports = new ArrayList<ImportPackageSpecification>();
        ImportPackageSpecification[] importPackages = b.getImportPackages();
        if (importPackages != null) {
            for (ImportPackageSpecification importPackage : importPackages) {
                String res = (String)importPackage.getDirective("resolution");
                if (!resolution.equals(res)) continue;
                imports.add(importPackage);
            }
        }
        return imports;
    }

    private void displayRequiredBundles(BundleDescription b) {
        BundleSpecification[] bundles = b.getRequiredBundles();
        if (bundles != null && bundles.length > 0) {
            System.out.println("Requires Bundles:");
            for (BundleSpecification bundle : bundles) {
                System.out.println("  " + bundle.getName());
            }
            System.out.println();
        }
    }

    private void displayFragments(BundleDescription b) {
        HostSpecification host = b.getHost();
        if (host != null) {
            System.out.println("Fragments:");
            System.out.println("  " + host);
            System.out.println();
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }
}

