/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.module;

import java.io.IOException;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.geronimo.module.ModuleMojoSupport;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;

public class InstallPluginMojo
extends ModuleMojoSupport {
    private boolean startModules = false;
    private org.apache.maven.artifact.Artifact projectArtifact;
    private String moduleId;
    private ArtifactRepository artifactRepository;
    private String defaultGeronimoRepository;

    public void execute() throws MojoExecutionException {
        if (this.moduleId == null) {
            this.moduleId = this.projectArtifact.getGroupId() + "/" + this.projectArtifact.getArtifactId() + "/" + this.projectArtifact.getVersion() + "/" + this.projectArtifact.getType();
            this.getLog().info((CharSequence)"using project artifact");
        }
        this.getLog().info((CharSequence)("moduleId: " + this.moduleId));
        this.getLog().info((CharSequence)("artifactRepository: " + this.artifactRepository));
        Artifact geronimoArtifact = Artifact.create((String)this.moduleId);
        PluginListType pluginListType = new PluginListType();
        String defaultRepository = this.artifactRepository.getBasedir();
        if (this.defaultGeronimoRepository != null) {
            pluginListType.getDefaultRepository().add(this.defaultGeronimoRepository);
            defaultRepository = this.defaultGeronimoRepository;
        }
        pluginListType.getDefaultRepository().add(this.artifactRepository.getBasedir());
        PluginType pluginType = new PluginType();
        pluginListType.getPlugin().add(pluginType);
        PluginArtifactType instance = new PluginArtifactType();
        pluginType.getPluginArtifact().add(instance);
        ArtifactType artifactType = PluginInstallerGBean.toArtifactType((Artifact)geronimoArtifact);
        instance.setModuleId(artifactType);
        GeronimoDeploymentManager mgr = this.getDeploymentManager2();
        Object key = mgr.startInstall(pluginListType, defaultRepository, false, null, null);
        InstallPluginMojo.waitTillDone(mgr, key);
        if (this.startModules) {
            TargetModuleID[] allModules;
            this.getLog().info((CharSequence)"Starting modules...");
            Target[] allTargets = mgr.getTargets();
            try {
                allModules = mgr.getAvailableModules(null, allTargets);
            }
            catch (TargetException e) {
                throw new MojoExecutionException("Unable to load module list from server", (Exception)((Object)e));
            }
            TargetModuleID id = null;
            for (TargetModuleID test : allModules) {
                if (!geronimoArtifact.matches(Artifact.create((String)test.getModuleID()))) continue;
                id = test;
                break;
            }
            if (id == null) {
                throw new MojoExecutionException("Just installed plugin cannot be located");
            }
            TargetModuleID[] ids = new TargetModuleID[]{id};
            ProgressObject progress = this.getDeploymentManager2().start(ids);
            DeploymentStatus status = null;
            try {
                status = this.waitFor(progress);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Interrupted waiting for start completion", (Exception)e);
            }
            if (status.isFailed()) {
                throw new MojoExecutionException("Failed to start modules: " + status.getMessage());
            }
            this.getLog().info((CharSequence)"Started module(s):");
            this.logModules(ids, "    ");
        }
    }

    private GeronimoDeploymentManager getDeploymentManager2() throws MojoExecutionException {
        try {
            return (GeronimoDeploymentManager)this.getDeploymentManager();
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not communicate with server", (Exception)e);
        }
        catch (DeploymentManagerCreationException e) {
            throw new MojoExecutionException("Could not create deployment manager", (Exception)((Object)e));
        }
    }

    static DownloadResults waitTillDone(GeronimoDeploymentManager mgr, Object key) throws MojoExecutionException {
        while (true) {
            DownloadResults results;
            if ((results = mgr.checkOnInstall(key)).isFinished()) {
                if (results.isFailed()) {
                    throw new MojoExecutionException("Failed to install plugin");
                }
                return results;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Failed to install plugin, interrupted");
            }
        }
    }

    protected String getFullClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

