/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProxy {
    private static final Logger log = LoggerFactory.getLogger(ServerProxy.class);
    private JMXServiceURL url;
    private JMXConnector connector;
    private Map environment;
    private MBeanServerConnection mbeanConnection;
    private Throwable lastError;

    public ServerProxy(JMXServiceURL url, Map environment) throws Exception {
        assert (url != null);
        assert (environment != null);
        this.url = url;
        this.environment = environment;
        log.debug("Initialized with URL: " + url + ", environment: " + environment);
    }

    public ServerProxy(String hostname, int port, String username, String password) throws Exception {
        this("service:jmx:rmi://" + hostname + "/jndi/rmi://" + hostname + ":" + port + "/JMXConnector", username, password);
    }

    public ServerProxy(String url, String username, String password) throws Exception {
        assert (url != null);
        assert (username != null);
        assert (password != null);
        this.url = new JMXServiceURL(url);
        this.environment = new HashMap();
        this.environment.put("jmx.remote.credentials", new String[]{username, password});
        log.debug("Initialized with URL: " + url + ", environment: " + this.environment);
    }

    private MBeanServerConnection getConnection() throws IOException {
        if (this.mbeanConnection == null) {
            log.debug("Connecting to: " + this.url);
            this.connector = JMXConnectorFactory.connect(this.url, this.environment);
            this.mbeanConnection = this.connector.getMBeanServerConnection();
            log.debug("Connected");
        }
        return this.mbeanConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                String msg = "Failed to close JMXConnector";
                if (log.isTraceEnabled()) {
                    log.trace(msg, (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug(msg + ":" + e);
                }
            }
            finally {
                this.connector = null;
                this.mbeanConnection = null;
                this.lastError = null;
            }
        }
    }

    public boolean isFullyStarted() {
        boolean fullyStarted = true;
        try {
            AbstractNameQuery query = new AbstractNameQuery(PersistentConfigurationList.class.getName());
            Set result = this.listGBeans(query);
            for (AbstractName name : result) {
                boolean started = this.getBooleanAttribute(name, "kernelFullyStarted");
                if (started) continue;
                fullyStarted = false;
                break;
            }
        }
        catch (IOException e) {
            String msg = "Connection failure; ignoring";
            if (log.isTraceEnabled()) {
                log.trace(msg, (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug(msg + ": " + e);
            }
            fullyStarted = false;
            this.lastError = e;
        }
        catch (Exception e) {
            String msg = "Unable to determine if the server is fully started; ignoring";
            if (log.isTraceEnabled()) {
                log.trace(msg, (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug(msg + ": " + e);
            }
            fullyStarted = false;
            this.lastError = e;
        }
        return fullyStarted;
    }

    public String getGeronimoHome() {
        String home = null;
        try {
            AbstractName name;
            AbstractNameQuery query = new AbstractNameQuery(ServerInfo.class.getName());
            Set result = this.listGBeans(query);
            Iterator iter = result.iterator();
            while (iter.hasNext() && (home = (String)this.getAttribute(name = (AbstractName)iter.next(), "currentBaseDirectory")) == null) {
            }
        }
        catch (IOException e) {
            String msg = "Connection failure; ignoring";
            if (log.isTraceEnabled()) {
                log.trace(msg, (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug(msg + ": " + e);
            }
            this.lastError = e;
        }
        catch (Exception e) {
            String msg = "Unable to determine if the server is fully started; ignoring";
            if (log.isTraceEnabled()) {
                log.trace(msg, (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug(msg + ": " + e);
            }
            this.lastError = e;
        }
        return home;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void shutdown() {
        try {
            this.invoke("shutdown");
        }
        catch (Exception e) {
            log.warn("Unable to shutdown the server", (Throwable)e);
            this.lastError = e;
        }
    }

    private Object invoke(String operation, Object[] args, String[] signature) throws Exception {
        assert (operation != null);
        assert (args != null);
        assert (signature != null);
        return this.getConnection().invoke(Kernel.KERNEL, operation, args, signature);
    }

    private Object invoke(String operation, Object[] args) throws Exception {
        assert (args != null);
        String[] signature = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            signature[i] = args[i].getClass().getName();
        }
        return this.invoke(operation, args, signature);
    }

    private Object invoke(String operation) throws Exception {
        return this.invoke(operation, new Object[0]);
    }

    private Set listGBeans(AbstractNameQuery query) throws Exception {
        return (Set)this.invoke("listGBeans", new Object[]{query});
    }

    private Object getAttribute(AbstractName name, String attribute) throws Exception {
        assert (name != null);
        assert (attribute != null);
        return this.invoke("getAttribute", new Object[]{name, attribute});
    }

    private boolean getBooleanAttribute(AbstractName name, String attribute) throws Exception {
        Object obj = this.getAttribute(name, attribute);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new RuntimeException("Attribute is not of type Boolean: " + attribute);
    }
}

