/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.server;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.geronimo.mavenplugins.geronimo.ServerProxy;
import org.apache.geronimo.mavenplugins.geronimo.reporting.ReportingMojoSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.util.ObjectHolder;

public class WaitForServerMojo
extends ReportingMojoSupport {
    private int timeout = -1;
    private Timer timer = new Timer(true);

    protected void doExecute() throws Exception {
        this.log.info((CharSequence)"Waiting for Geronimo server...");
        final ObjectHolder verifyTimedOut = new ObjectHolder();
        TimerTask timeoutTask = new TimerTask(){

            public void run() {
                verifyTimedOut.set((Object)Boolean.TRUE);
            }
        };
        if (this.timeout > 0) {
            this.log.debug((CharSequence)("Starting verify timeout task; triggers in: " + this.timeout + "s"));
            this.timer.schedule(timeoutTask, this.timeout * 1000);
        }
        ServerProxy server = new ServerProxy(this.hostname, this.port, this.username, this.password);
        boolean started = false;
        while (!started) {
            if (verifyTimedOut.isSet()) {
                throw new MojoExecutionException("Unable to verify if the server was started in the given time");
            }
            started = server.isFullyStarted();
            if (started) continue;
            Throwable error = server.getLastError();
            if (error != null) {
                this.log.debug((CharSequence)"Server query failed; ignoring", error);
            }
            Thread.sleep(1000L);
        }
        server.closeConnection();
        timeoutTask.cancel();
        this.log.info((CharSequence)"Geronimo server started");
    }

    protected String getFullClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

