/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.time.StopWatch;
import org.apache.geronimo.mavenplugins.geronimo.ServerProxy;
import org.apache.geronimo.mavenplugins.geronimo.server.InstallerMojoSupport;
import org.apache.geronimo.mavenplugins.geronimo.server.OptionSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.mojo.pluginsupport.util.ObjectHolder;
import org.codehaus.plexus.util.FileUtils;

public class StartServerMojo
extends InstallerMojoSupport {
    private boolean install = true;
    private boolean background = false;
    private String maximumMemory = null;
    private File javaVirtualMachine;
    private boolean quiet = false;
    private boolean verbose = false;
    private boolean veryverbose = false;
    private int timeout = -1;
    private int verifyTimeout = -1;
    private boolean propagateGeronimoProperties;
    private OptionSet[] optionSets = null;
    private String options = null;
    private String[] startModules = null;
    private Timer timer = new Timer(true);

    protected void doExecute() throws Exception {
        File javaAgentJar;
        if (this.install) {
            this.installAssembly();
        } else {
            this.log.info((CharSequence)"Skipping assembly installation");
            if (!this.geronimoHome.exists()) {
                throw new MojoExecutionException("Missing pre-installed assembly directory: " + this.geronimoHome);
            }
        }
        this.log.info((CharSequence)"Starting Geronimo server...");
        final Java java = (Java)this.createTask("java");
        java.setJar(new File(this.geronimoHome, "bin/server.jar"));
        java.setDir(this.geronimoHome);
        java.setFailonerror(true);
        java.setFork(true);
        if (this.javaVirtualMachine != null) {
            if (!this.javaVirtualMachine.exists()) {
                throw new MojoExecutionException("Java virtual machine is not valid: " + this.javaVirtualMachine);
            }
            this.log.info((CharSequence)("Using Java virtual machine: " + this.javaVirtualMachine));
            java.setJvm(this.javaVirtualMachine.getCanonicalPath());
        }
        if (this.timeout > 0) {
            java.setTimeout(new Long(this.timeout * 1000));
        }
        if (this.maximumMemory != null) {
            java.setMaxmemory(this.maximumMemory);
        }
        if ((javaAgentJar = new File(this.geronimoHome, "bin/jpa.jar")).exists()) {
            java.createJvmarg().setValue("-javaagent:" + javaAgentJar.getCanonicalPath());
        }
        if (this.propagateGeronimoProperties) {
            Properties props = System.getProperties();
            for (String string : props.keySet()) {
                String value = System.getProperty(string);
                if (string.equals("geronimo.bootstrap.logging.enabled") || !string.startsWith("org.apache.geronimo") && !string.startsWith("geronimo")) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Propagating: " + string + "=" + value));
                }
                this.setSystemProperty(java, string, value);
            }
        }
        if (this.options != null && (this.optionSets == null || this.optionSets.length == 0)) {
            throw new MojoExecutionException("At least one optionSet must be defined to select one using options");
        }
        if (this.options == null) {
            this.options = "default";
        }
        if (this.optionSets != null && this.optionSets.length != 0) {
            OptionSet[] sets = this.selectOptionSets();
            for (int i = 0; i < sets.length; ++i) {
                Properties props;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Selected option set: " + sets[i]));
                } else {
                    this.log.info((CharSequence)("Selected option set: " + sets[i].getId()));
                }
                String[] stringArray = sets[i].getOptions();
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        java.createJvmarg().setValue(stringArray[j]);
                    }
                }
                if ((props = sets[i].getProperties()) == null) continue;
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    this.setSystemProperty(java, string, value);
                }
            }
        }
        this.setSystemProperty(java, "org.apache.geronimo.home.dir", this.geronimoHome);
        this.setSystemProperty(java, "java.io.tmpdir", "var/temp");
        this.setSystemProperty(java, "java.endorsed.dirs", this.prefixSystemPath("java.endorsed.dirs", new File(this.geronimoHome, "lib/endorsed")));
        this.setSystemProperty(java, "java.ext.dirs", this.prefixSystemPath("java.ext.dirs", new File(this.geronimoHome, "lib/ext")));
        if (this.quiet) {
            java.createArg().setValue("--quiet");
        } else {
            java.createArg().setValue("--long");
        }
        if (this.verbose) {
            java.createArg().setValue("--verbose");
        }
        if (this.veryverbose) {
            java.createArg().setValue("--veryverbose");
        }
        if (this.startModules != null) {
            if (this.startModules.length == 0) {
                throw new MojoExecutionException("At least one module name must be configured with startModule");
            }
            this.log.info((CharSequence)"Overriding the set of modules to be started");
            java.createArg().setValue("--override");
            for (int i = 0; i < this.startModules.length; ++i) {
                java.createArg().setValue(this.startModules[i]);
            }
        }
        if (this.logOutput) {
            File file = this.getLogFile();
            FileUtils.forceMkdir((File)file.getParentFile());
            this.log.info((CharSequence)("Redirecting output to: " + file));
            java.setOutput(file);
        }
        final ObjectHolder errorHolder = new ObjectHolder();
        StopWatch watch = new StopWatch();
        watch.start();
        Thread thread = new Thread("Geronimo Server Runner"){

            public void run() {
                try {
                    java.execute();
                }
                catch (Exception e) {
                    errorHolder.set((Object)e);
                }
            }
        };
        thread.start();
        this.log.info((CharSequence)"Waiting for Geronimo server...");
        final ObjectHolder verifyTimedOut = new ObjectHolder();
        TimerTask timeoutTask = new TimerTask(){

            public void run() {
                verifyTimedOut.set((Object)Boolean.TRUE);
            }
        };
        if (this.verifyTimeout > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Starting verify timeout task; triggers in: " + this.verifyTimeout + " seconds"));
            }
            this.timer.schedule(timeoutTask, this.verifyTimeout * 1000);
        }
        ServerProxy serverProxy = new ServerProxy(this.hostname, this.port, this.username, this.password);
        boolean started = false;
        while (!started) {
            if (verifyTimedOut.isSet()) {
                throw new MojoExecutionException("Unable to verify if the server was started in the given time (" + this.verifyTimeout + " seconds)");
            }
            if (errorHolder.isSet()) {
                throw new MojoExecutionException("Failed to start Geronimo server", (Throwable)errorHolder.get());
            }
            started = serverProxy.isFullyStarted();
            if (started) continue;
            Throwable error = serverProxy.getLastError();
            if (error != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Server query failed; ignoring", error);
            }
            Thread.sleep(1000L);
        }
        serverProxy.closeConnection();
        timeoutTask.cancel();
        this.log.info((CharSequence)("Geronimo server started in " + watch));
        if (!this.background) {
            this.log.info((CharSequence)"Waiting for Geronimo server to shutdown...");
            thread.join();
        }
    }

    private String prefixSystemPath(String name, File file) {
        assert (name != null);
        assert (file != null);
        String dirs = file.getPath();
        String prop = System.getProperty(name, "");
        if (prop.length() > 0) {
            dirs = dirs + File.pathSeparator;
            dirs = dirs + prop;
        }
        return dirs;
    }

    private OptionSet[] selectOptionSets() throws MojoExecutionException {
        HashMap<String, OptionSet> map = new HashMap<String, OptionSet>();
        for (int i = 0; i < this.optionSets.length; ++i) {
            String id;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Checking option set: " + this.optionSets[i]));
            }
            if ((id = this.optionSets[i].getId()) == null && this.optionSets.length > 1) {
                throw new MojoExecutionException("Must specify id for optionSet when more than one optionSet is configured");
            }
            if (id == null && this.optionSets.length == 1) {
                id = "default";
                this.optionSets[i].setId(id);
            }
            assert (id != null);
            if (map.containsKey(id = id.trim())) {
                throw new MojoExecutionException("Must specify unique id for optionSet: " + id);
            }
            map.put(id, this.optionSets[i]);
        }
        StringTokenizer stok = new StringTokenizer(this.options, ",");
        ArrayList<OptionSet> selected = new ArrayList<OptionSet>();
        while (stok.hasMoreTokens()) {
            String id = stok.nextToken();
            OptionSet set = (OptionSet)map.get(id);
            if (set == null) {
                if ("default".equals(id)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((CharSequence)"Default optionSet selected, but no optionSet defined with that id; ignoring");
                    continue;
                }
                this.log.warn((CharSequence)("Missing optionSet for id: " + id));
                continue;
            }
            selected.add(set);
        }
        return selected.toArray(new OptionSet[selected.size()]);
    }

    protected String getFullClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

