/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.server;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.mavenplugins.geronimo.AssemblyConfig;
import org.apache.geronimo.mavenplugins.geronimo.reporting.ReportingMojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.plexus.util.FileUtils;

public abstract class InstallerMojoSupport
extends ReportingMojoSupport {
    protected boolean refresh = false;
    protected AssemblyConfig[] assemblies = null;
    protected String assemblyId = null;
    protected String defaultAssemblyId = null;
    protected File assemblyArchive = null;
    protected File installDirectory = null;
    protected File geronimoHome;
    protected InstallType installType;

    private File discoverGeronimoHome(File archive) throws IOException, MojoExecutionException {
        this.log.debug((CharSequence)"Attempting to discover geronimoHome...");
        File dir = null;
        try {
            ZipFile zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> n = zipFile.entries();
            while (n.hasMoreElements()) {
                ZipEntry entry = n.nextElement();
                if (!entry.getName().endsWith("bin/server.jar")) continue;
                File file = new File(this.installDirectory, entry.getName());
                dir = file.getParentFile().getParentFile();
                break;
            }
            zipFile.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to determine geronimoHome while scanning archive for 'bin/server.jar'", (Exception)e);
        }
        if (dir == null) {
            throw new MojoExecutionException("Archive does not contain a Geronimo assembly: " + archive);
        }
        return dir.getCanonicalFile();
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        try {
            if (this.geronimoHome != null) {
                this.geronimoHome = this.geronimoHome.getCanonicalFile();
                File file = new File(this.geronimoHome, "bin/server.jar");
                if (!file.exists()) {
                    throw new MojoExecutionException("When geronimoHome is set, it must point to a directory that contains 'bin/server.jar'");
                }
                this.log.info((CharSequence)("Using pre-installed assembly: " + this.geronimoHome));
                this.installType = InstallType.ALREADY_EXISTS;
            } else {
                if (this.assemblyArchive != null) {
                    this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                    this.log.info((CharSequence)("Using non-artifact based assembly archive: " + this.assemblyArchive));
                    this.installType = InstallType.FROM_FILE;
                } else {
                    Artifact artifact = this.getAssemblyArtifact();
                    if (!"zip".equals(artifact.getType())) {
                        throw new MojoExecutionException("Assembly file does not look like a ZIP archive");
                    }
                    this.log.info((CharSequence)("Using assembly artifact: " + artifact));
                    this.assemblyArchive = artifact.getFile();
                    this.installType = InstallType.FROM_ARTIFACT;
                }
                this.geronimoHome = this.discoverGeronimoHome(this.assemblyArchive);
                this.log.info((CharSequence)("Using geronimoHome: " + this.geronimoHome));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected Artifact getAssemblyArtifact() throws MojoExecutionException {
        AssemblyConfig config;
        if (this.assemblies == null || this.assemblies.length == 0) {
            throw new MojoExecutionException("At least one assembly configuration must be specified");
        }
        if (this.assemblies.length > 1 && this.assemblyId == null && this.defaultAssemblyId == null) {
            throw new MojoExecutionException("Must specify assemblyId (or defaultAssemblyId) when more than on assembly configuration is given");
        }
        if (this.assemblies.length == 1) {
            config = this.assemblies[0];
        } else {
            if (this.assemblyId == null) {
                this.assemblyId = this.defaultAssemblyId;
            }
            this.log.debug((CharSequence)("Searching for assembly config for id: " + this.assemblyId));
            HashMap<String, AssemblyConfig> idMap = new HashMap<String, AssemblyConfig>();
            for (int i = 0; i < this.assemblies.length; ++i) {
                String id = this.assemblies[i].getId();
                if (id == null) {
                    throw new MojoExecutionException("Missing id for assembly configuration: " + (Object)((Object)this.assemblies[i]));
                }
                if (idMap.containsKey(id)) {
                    throw new MojoExecutionException("Duplicate assembly id: " + id);
                }
                idMap.put(id, this.assemblies[i]);
            }
            config = (AssemblyConfig)((Object)idMap.get(this.assemblyId));
            if (config == null) {
                throw new MojoExecutionException("Missing assembly configuration for id: " + this.assemblyId);
            }
        }
        this.log.info((CharSequence)("Using assembly configuration: " + config.getId()));
        Artifact artifact = this.getArtifact(config);
        if (artifact.getFile() == null) {
            throw new MojoExecutionException("Assembly artifact does not have an attached file: " + artifact);
        }
        return artifact;
    }

    protected void installAssembly() throws Exception {
        if (this.installType == InstallType.ALREADY_EXISTS) {
            this.log.info((CharSequence)"Installation type is pre-existing; skipping installation");
            return;
        }
        File installMarker = new File(this.geronimoHome, ".installed");
        if (!this.refresh) {
            if (!installMarker.exists()) {
                this.refresh = true;
            } else if (this.assemblyArchive.lastModified() > installMarker.lastModified()) {
                this.log.debug((CharSequence)"Detected new assembly archive");
                this.refresh = true;
            }
        } else {
            this.log.debug((CharSequence)"User requested installation refresh");
        }
        if (this.refresh && this.geronimoHome.exists()) {
            this.log.info((CharSequence)("Uninstalling: " + this.geronimoHome));
            FileUtils.forceDelete((File)this.geronimoHome);
        }
        if (!installMarker.exists()) {
            this.log.info((CharSequence)"Installing assembly...");
            FileUtils.forceMkdir((File)this.geronimoHome);
            Expand unzip = (Expand)this.createTask("unzip");
            unzip.setSrc(this.assemblyArchive);
            unzip.setDest(this.installDirectory.getCanonicalFile());
            unzip.execute();
            Chmod chmod = (Chmod)this.createTask("chmod");
            chmod.setPerm("ugo+rx");
            chmod.setDir(this.geronimoHome);
            chmod.setIncludes("bin/*");
            chmod.setExcludes("bin/*.bat");
            chmod.execute();
            installMarker.createNewFile();
        } else {
            this.log.info((CharSequence)"Re-using previously installed assembly");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum InstallType {
        FROM_ARTIFACT,
        FROM_FILE,
        ALREADY_EXISTS;

    }
}

