/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class UpdatePluginListMojo
extends AbstractCarMojo {
    protected File targetFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            PluginListType pluginList;
            PluginType plugin;
            FileInputStream min = new FileInputStream(this.targetFile);
            try {
                plugin = PluginXmlUtil.loadPluginMetadata((InputStream)min);
            }
            finally {
                ((InputStream)min).close();
            }
            String path = this.getArtifactRepository().getBasedir();
            File baseDir = new File(path);
            File outFile = new File(baseDir, "geronimo-plugins.xml");
            if (outFile.exists()) {
                FileInputStream in = new FileInputStream(outFile);
                try {
                    pluginList = PluginXmlUtil.loadPluginList((InputStream)in);
                }
                finally {
                    ((InputStream)in).close();
                }
            } else {
                pluginList = new PluginListType();
                pluginList.getDefaultRepository().add(path);
            }
            this.updatePluginList(plugin, pluginList);
            FileWriter out = new FileWriter(outFile, false);
            try {
                PluginXmlUtil.writePluginList((PluginListType)pluginList, (Writer)out);
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not update plugin list", e);
        }
    }

    public void updatePluginList(PluginType plugin, PluginListType pluginList) throws NoSuchStoreException {
        PluginType key = PluginInstallerGBean.toKey((PluginType)plugin);
        PluginArtifactType instance = (PluginArtifactType)plugin.getPluginArtifact().get(0);
        Artifact id = PluginInstallerGBean.toArtifact((ArtifactType)instance.getModuleId());
        boolean foundKey = false;
        boolean foundModule = false;
        Iterator pit = pluginList.getPlugin().iterator();
        while (pit.hasNext()) {
            PluginType test = (PluginType)pit.next();
            Iterator it = test.getPluginArtifact().iterator();
            while (it.hasNext()) {
                PluginArtifactType testInstance = (PluginArtifactType)it.next();
                Artifact testId = PluginInstallerGBean.toArtifact((ArtifactType)testInstance.getModuleId());
                if (!id.equals((Object)testId)) continue;
                it.remove();
                foundModule = true;
            }
            PluginType testKey = PluginInstallerGBean.toKey((PluginType)test);
            if (key.equals(testKey)) {
                foundKey = true;
                test.getPluginArtifact().add(instance);
            }
            if (foundKey || !foundModule || test.getPluginArtifact().size() != 0) continue;
            pit.remove();
        }
        if (!foundKey) {
            pluginList.getPlugin().add(plugin);
        }
    }
}

