/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Maven2Repository;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.obr.GeronimoOBRGBean;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.LicenseType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PluginMetadataGeneratorMojo
extends AbstractCarMojo {
    private File targetRepository = null;
    protected File targetDir = null;
    protected String pluginMetadataFileName = null;
    protected String obrFileName;
    private boolean osiApproved;
    private String category;
    private boolean pluginGroup;
    private List<Dependency> dependencies = Collections.emptyList();
    private Dependency module = null;
    private UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, true);
    private PlexusConfiguration commonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            PluginArtifactType instance;
            Plugin plugin;
            PluginType metadata = new PluginType();
            metadata.setName(this.project.getName());
            metadata.setAuthor(this.project.getOrganization() == null ? "unknown" : this.project.getOrganization().getName());
            metadata.setUrl(this.project.getOrganization() == null ? "unknown" : this.project.getOrganization().getUrl());
            metadata.setDescription(this.project.getDescription());
            metadata.setCategory(this.category);
            metadata.setPluginGroup(Boolean.valueOf(this.pluginGroup));
            if (this.project.getLicenses() != null) {
                for (Object licenseObj : this.project.getLicenses()) {
                    License license = (License)licenseObj;
                    LicenseType licenseType = new LicenseType();
                    licenseType.setValue(license.getName());
                    licenseType.setOsiApproved(this.osiApproved);
                    metadata.getLicense().add(licenseType);
                }
            }
            if ((plugin = (Plugin)this.project.getModel().getBuild().getPluginsAsMap().get("org.apache.geronimo.buildsupport:car-maven-plugin")) == null) {
                throw new Error("Unable to resolve car plugin");
            }
            Xpp3Dom dom = null;
            if (plugin.getExecutions().isEmpty()) {
                dom = (Xpp3Dom)plugin.getConfiguration();
            } else {
                for (PluginExecution execution : plugin.getExecutions()) {
                    if (!"prepare-metadata".equals(execution.getGoals().get(0))) continue;
                    dom = (Xpp3Dom)execution.getConfiguration();
                    break;
                }
                if (dom == null) {
                    throw new IllegalStateException("Cannot determine correct configuration for PluginMetadataGeneratorMojo: " + plugin.getExecutionsAsMap());
                }
            }
            Xpp3Dom instanceDom = dom.getChild("instance");
            if (instanceDom == null || instanceDom.getChild("plugin-artifact") == null) {
                instance = new PluginArtifactType();
            } else {
                String instanceString = instanceDom.getChild("plugin-artifact").toString();
                instance = PluginXmlUtil.loadPluginArtifactMetadata((Reader)new StringReader(instanceString.replace("#{", "${")));
            }
            if (this.commonInstance != null && this.commonInstance.getChild("plugin-artifact") != null) {
                PluginArtifactType commonInstance = PluginXmlUtil.loadPluginArtifactMetadata((Reader)new StringReader(this.commonInstance.getChild("plugin-artifact").toString().replace("#{", "${")));
                if (instance.getArtifactAlias().isEmpty()) {
                    instance.getArtifactAlias().addAll(commonInstance.getArtifactAlias());
                }
                if (instance.getConfigSubstitution().isEmpty()) {
                    instance.getConfigSubstitution().addAll(commonInstance.getConfigSubstitution());
                }
                if (instance.getCopyFile().isEmpty()) {
                    instance.getCopyFile().addAll(commonInstance.getCopyFile());
                }
                if (instance.getDependency().isEmpty()) {
                    instance.getDependency().addAll(commonInstance.getDependency());
                }
                if (instance.getGeronimoVersion().isEmpty()) {
                    instance.getGeronimoVersion().addAll(commonInstance.getGeronimoVersion());
                }
                if (instance.getJvmVersion().isEmpty()) {
                    instance.getJvmVersion().addAll(commonInstance.getJvmVersion());
                }
                if (instance.getObsoletes().isEmpty()) {
                    instance.getObsoletes().addAll(commonInstance.getObsoletes());
                }
                if (instance.getPrerequisite().isEmpty()) {
                    instance.getPrerequisite().addAll(commonInstance.getPrerequisite());
                }
                if (instance.getSourceRepository().isEmpty()) {
                    instance.getSourceRepository().addAll(commonInstance.getSourceRepository());
                }
            }
            metadata.getPluginArtifact().add(instance);
            ArtifactType artifactType = this.getModuleId();
            ArtifactType existingArtifact = instance.getModuleId();
            if (existingArtifact != null && existingArtifact.getType() != null) {
                artifactType.setType(existingArtifact.getType());
            }
            instance.setModuleId(artifactType);
            this.addDependencies(instance);
            if (this.module != null) {
                this.removeIncludedModule(instance.getDependency(), this.module);
            }
            this.targetDir.mkdirs();
            File targetFile = new File(this.targetDir.toURI().resolve(this.pluginMetadataFileName));
            targetFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(targetFile);
            try {
                PluginXmlUtil.writePluginMetadata((PluginType)metadata, (OutputStream)out);
            }
            finally {
                out.close();
            }
            Resource resource = new Resource();
            resource.setDirectory(this.targetDir.getPath());
            resource.addInclude(this.pluginMetadataFileName);
            this.getProject().getResources().add(resource);
            this.projectHelper.attachArtifact(this.getProject(), "plugin-metadata", targetFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create plugin metadata", e);
        }
        try {
            File obr = new File(this.targetDir.toURI().resolve(this.obrFileName));
            obr.getParentFile().mkdirs();
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (org.apache.maven.artifact.Artifact artifact : this.localDependencies) {
                artifacts.add(this.mavenToGeronimoArtifact(artifact));
            }
            Maven2Repository repo = new Maven2Repository(new File(this.getArtifactRepository().getBasedir()));
            GeronimoOBRGBean.generateOBR((String)this.project.getName(), artifacts, (Repository)repo, (File)obr);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not construct obr repository.xml", e);
        }
    }

    private void addDependencies(PluginArtifactType instance) throws InvalidConfigException, IOException, NoSuchConfigException, InvalidDependencyVersionException, ArtifactResolutionException, ProjectBuildingException, MojoExecutionException {
        LinkedHashSet<DependencyType> resolvedDependencies = this.toDependencies(this.dependencies, this.useMavenDependencies, false);
        instance.getDependency().addAll(resolvedDependencies);
    }

    private void removeIncludedModule(List<DependencyType> sourceList, Dependency removeTarget) {
        block0: {
            DependencyType dependencyType;
            Iterator<DependencyType> i$ = sourceList.iterator();
            if (!i$.hasNext() || !(dependencyType = i$.next()).toArtifact().equals((Object)removeTarget.toArtifactType().toArtifact())) break block0;
            sourceList.remove(dependencyType);
        }
    }
}

