/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.osgi.BootActivator;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class PlanProcessorMojo
extends AbstractCarMojo {
    private static final String ENVIRONMENT_LOCAL_NAME = "environment";
    private static final QName ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "environment");
    protected File sourceFile = null;
    protected File targetDir = null;
    protected File targetFile = null;
    private List<Dependency> dependencies = Collections.emptyList();
    UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, true);
    protected File filteredPlanFile;
    private boolean boot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.sourceFile.exists()) {
            this.getLog().info((CharSequence)"No plan found, plugin will have no classloader");
            return;
        }
        try {
            this.filter(this.sourceFile, this.filteredPlanFile);
            XmlObject doc = XmlObject.Factory.parse((File)this.filteredPlanFile);
            XmlCursor xmlCursor = doc.newCursor();
            LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> dependencies = this.toKernelDependencies(this.useMavenDependencies);
            Artifact configId = new Artifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "car");
            try {
                this.mergeEnvironment(xmlCursor, configId, dependencies);
                if (this.targetDir.exists()) {
                    if (!this.targetDir.isDirectory()) {
                        throw new RuntimeException("TargetDir: " + this.targetDir + " exists and is not a directory");
                    }
                } else {
                    this.targetDir.mkdirs();
                }
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.setSavePrettyPrint();
                doc.save(this.targetFile, xmlOptions);
                if (this.getLog() != null) {
                    this.getLog().info((CharSequence)("Generated: " + this.targetFile));
                }
            }
            finally {
                xmlCursor.dispose();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not process plan", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeEnvironment(XmlCursor xmlCursor, Artifact configId, LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> dependencies) {
        Environment oldEnvironment;
        EnvironmentType environmentType;
        QName childName;
        this.moveToFirstStartElement(xmlCursor);
        boolean atLeastOneChild = xmlCursor.toFirstChild();
        if (!atLeastOneChild) {
            xmlCursor.toEndToken();
        }
        if ((childName = xmlCursor.getName()) != null && childName.getLocalPart().equals(ENVIRONMENT_LOCAL_NAME)) {
            this.convertElement(xmlCursor, ENVIRONMENT_QNAME.getNamespaceURI());
            XmlObject xmlObject = xmlCursor.getObject();
            environmentType = (EnvironmentType)xmlObject.copy().changeType(EnvironmentType.type);
            oldEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType);
            xmlCursor.removeXml();
        } else {
            oldEnvironment = new Environment();
        }
        Environment newEnvironment = new Environment();
        newEnvironment.setConfigId(configId);
        newEnvironment.setDependencies(dependencies);
        if (this.boot) {
            newEnvironment.setBundleActivator(BootActivator.class.getName());
        }
        EnvironmentBuilder.mergeEnvironments((Environment)oldEnvironment, (Environment)newEnvironment);
        environmentType = EnvironmentBuilder.buildEnvironmentType((Environment)oldEnvironment);
        xmlCursor.beginElement(ENVIRONMENT_QNAME);
        XmlCursor element = environmentType.newCursor();
        try {
            element.copyXmlContents(xmlCursor);
        }
        finally {
            element.dispose();
        }
    }

    private void moveToFirstStartElement(XmlCursor xmlCursor) throws AssertionError {
        xmlCursor.toStartDoc();
        xmlCursor.toFirstChild();
        while (!xmlCursor.currentTokenType().isStart() && xmlCursor.toNextSibling()) {
        }
        if (!xmlCursor.currentTokenType().isStart()) {
            throw new AssertionError((Object)"Cannot find first start element");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertElement(XmlCursor cursor, String namespace) {
        cursor.push();
        XmlCursor end = cursor.newCursor();
        try {
            end.toCursor(cursor);
            end.toEndToken();
            while (cursor.hasNextToken() && cursor.isLeftOf(end)) {
                if (cursor.isStart() && !namespace.equals(cursor.getName().getNamespaceURI())) {
                    cursor.setName(new QName(namespace, cursor.getName().getLocalPart()));
                }
                cursor.toNextToken();
            }
            cursor.pop();
        }
        finally {
            end.dispose();
        }
    }

    protected LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> toKernelDependencies(UseMavenDependencies useMavenDependencies) throws InvalidDependencyVersionException, ArtifactResolutionException, ProjectBuildingException, MojoExecutionException {
        LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency> kernelDependencies = new LinkedHashSet<org.apache.geronimo.kernel.repository.Dependency>();
        LinkedHashSet<DependencyType> dependencies = this.toDependencies(this.dependencies, useMavenDependencies, true);
        for (DependencyType dependency : dependencies) {
            kernelDependencies.add(Dependency.toKernelDependency(dependency));
        }
        return kernelDependencies;
    }

    static interface Inserter {
        public ArtifactType insert(EnvironmentType var1);
    }
}

