/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.system.plugin.LocalOpenResult;
import org.apache.geronimo.system.plugin.OpenResult;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.repository.Maven2Repository;

public class Maven2RepositoryAdapter
extends Maven2Repository
implements SourceRepository {
    private ArtifactLookup lookup;
    private Set<org.apache.maven.artifact.Artifact> dependencyTree;
    public static final GBeanInfo GBEAN_INFO;

    public Maven2RepositoryAdapter(Set<org.apache.maven.artifact.Artifact> dependencyTree, ArtifactLookup lookup) {
        super(lookup.getBasedir());
        this.dependencyTree = dependencyTree;
        this.lookup = lookup;
    }

    public File getLocation(Artifact artifact) {
        assert (artifact != null);
        return this.lookup.getLocation(artifact);
    }

    public SortedSet list() {
        TreeSet<Artifact> list = new TreeSet<Artifact>();
        this.listInternal(list, null, null, null, null);
        return list;
    }

    public SortedSet list(Artifact query) {
        TreeSet<Artifact> list = new TreeSet<Artifact>();
        this.listInternal(list, query.getGroupId(), query.getArtifactId(), query.getVersion(), query.getType());
        return list;
    }

    private void listInternal(TreeSet<Artifact> list, String groupId, String artifactId, Version version, String type) {
        for (org.apache.maven.artifact.Artifact artifact : this.dependencyTree) {
            if (!this.matches(artifact, groupId, artifactId, version, type)) continue;
            list.add(this.mavenToGeronimoArtifact(artifact));
        }
    }

    private boolean matches(org.apache.maven.artifact.Artifact artifact, String groupId, String artifactId, Version version, String type) {
        return !(groupId != null && !artifact.getGroupId().equals(groupId) || artifactId != null && !artifact.getArtifactId().equals(artifactId) || version != null && !artifact.getVersion().equals(version.toString()) || type != null && !artifact.getType().equals(type));
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.artifact.Artifact artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    public PluginListType getPluginList() {
        throw new RuntimeException("Not implemented");
    }

    public OpenResult open(Artifact artifact, FileWriteMonitor fileWriteMonitor) throws IOException, FailedLoginException {
        if (!artifact.isResolved()) {
            SortedSet list = this.list(artifact);
            if (list.isEmpty()) {
                throw new IOException("Could not resolve artifact " + artifact + " in repo " + this.rootFile);
            }
            artifact = (Artifact)list.first();
        }
        File location = this.getLocation(artifact);
        return new LocalOpenResult(artifact, location);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(Maven2RepositoryAdapter.class, (String)"Repository");
        infoFactory.addAttribute("lookup", ArtifactLookup.class, true);
        infoFactory.addAttribute("dependencies", Set.class, true);
        infoFactory.setConstructor(new String[]{"dependencies", "lookup"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    public static interface ArtifactLookup {
        public File getLocation(Artifact var1);

        public File getBasedir();
    }
}

