/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicKernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.geronimo.mavenplugins.car.Override;
import org.apache.geronimo.mavenplugins.car.ServerInstance;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.PluginRepositoryDownloader;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.resolver.AliasedArtifactResolver;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InstallModulesMojo
extends AbstractCarMojo {
    private File targetServerDirectory = null;
    private String targetRepositoryPath = null;
    private String targetConfigPath = null;
    private List<ServerInstance> servers;
    private String artifact = null;
    private ArtifactRepository sourceRepository = null;
    private File explicitResolutionProperties = null;
    private String installedPluginsList;
    private AliasedArtifactResolver geronimoArtifactResolver;
    private RepositoryConfigurationStore sourceStore;
    private File overridesDir;
    private List<Override> overrides;
    private Set installedArtifacts = new HashSet();
    private BundleContext bundleContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.bundleContext = this.getFramework("").getBundleContext();
        }
        catch (BundleException e) {
            throw new MojoExecutionException("Could not create osqi framework", (Exception)((Object)e));
        }
        this.getDependencies(this.project, false);
        AbstractCarMojo.ArtifactLookupImpl lookup = new AbstractCarMojo.ArtifactLookupImpl();
        Maven2RepositoryAdapter sourceRepo = new Maven2RepositoryAdapter(this.dependencyArtifacts, lookup);
        PluginListType pluginList = new PluginListType();
        String localRepo = this.sourceRepository.getUrl();
        if ("file".equals(this.sourceRepository.getProtocol())) {
            File localRepoDir = new File(this.sourceRepository.getBasedir());
            localRepo = localRepoDir.toURI().toString();
        }
        pluginList.getDefaultRepository().add(localRepo);
        for (Repository repository : this.project.getRepositories()) {
            pluginList.getDefaultRepository().add(repository.getUrl());
        }
        if (this.artifact != null) {
            pluginList.getPlugin().add(this.toPluginType(Artifact.create((String)this.artifact)));
        } else {
            this.addDependencies(pluginList);
        }
        DownloadResults downloadPoller = new DownloadResults();
        String targetServerPath = this.targetServerDirectory.getAbsolutePath();
        BasicKernel kernel = new BasicKernel("Assembly", this.bundleContext);
        PluginRepositoryDownloader pluginRepoList = new PluginRepositoryDownloader(Collections.singletonMap(localRepo, null), true);
        try {
            PluginInstallerGBean installer = new PluginInstallerGBean(this.targetRepositoryPath, targetServerPath, this.installedPluginsList, this.servers, (PluginRepositoryList)pluginRepoList, (Kernel)kernel, this.bundleContext);
            installer.install(pluginList, (SourceRepository)sourceRepo, true, null, null, (DownloadPoller)downloadPoller);
            if (this.overrides != null) {
                for (Override override : this.overrides) {
                    AttributesType attributes = override.getOverrides(this.overridesDir);
                    installer.mergeOverrides(override.getServer(), attributes);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not use plugin installer bean", e);
        }
        finally {
            kernel.shutdown();
            try {
                this.bundleContext.getBundle().stop();
            }
            catch (BundleException e) {}
        }
        this.getLog().info((CharSequence)"Installed plugins: ");
        for (Artifact artifact : downloadPoller.getInstalledConfigIDs()) {
            this.getLog().info((CharSequence)("    " + artifact));
        }
        this.getLog().info((CharSequence)"Installed dependencies: ");
        for (Artifact artifact : downloadPoller.getDependenciesInstalled()) {
            this.getLog().info((CharSequence)("    " + artifact));
        }
        if (downloadPoller.isFailed()) {
            throw new MojoExecutionException("Could not download all dependencies", downloadPoller.getFailure());
        }
        this.cleanup();
    }

    private PluginType toPluginType(Artifact artifact) {
        PluginType plugin = new PluginType();
        PluginArtifactType instance = new PluginArtifactType();
        ArtifactType artifactType = PluginInstallerGBean.toArtifactType((Artifact)artifact);
        instance.setModuleId(artifactType);
        plugin.getPluginArtifact().add(instance);
        return plugin;
    }

    protected void addDependencies(PluginListType pluginList) {
        List projectArtifacts;
        org.apache.maven.artifact.Artifact artifact = this.project.getArtifact();
        if (artifact != null && ("car".equals(artifact.getType()) || "jar".equals(artifact.getType())) && artifact.getFile() != null) {
            pluginList.getPlugin().add(this.toPluginType(this.mavenToGeronimoArtifact(artifact)));
        }
        if ((projectArtifacts = this.project.getModel().getDependencies()) != null) {
            for (Dependency dependency : projectArtifacts) {
                if (dependency.getScope() != null && !"compile".equals(dependency.getScope())) continue;
                pluginList.getPlugin().add(this.toPluginType(this.mavenToGeronimoArtifact(dependency)));
            }
        }
    }
}

