/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DependencyChangeMojo
extends AbstractCarMojo {
    private List<Dependency> dependencies = Collections.emptyList();
    private boolean warnOnDependencyChange;
    private boolean logDependencyChanges;
    private boolean overwriteChangedDependencies;
    private File dependencyFile;
    private File filteredDependencyFile;
    private UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block13: {
            UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, this.useMavenDependencies.isUseTransitiveDependencies());
            try {
                LinkedHashSet<DependencyType> dependencies = this.toDependencies(this.dependencies, useMavenDependencies, false);
                for (DependencyType test : dependencies) {
                    test.setStart(null);
                    test.setImport(null);
                }
                LinkedHashSet<DependencyType> added = new LinkedHashSet<DependencyType>(dependencies);
                if (this.dependencyFile.exists()) {
                    this.filter(this.dependencyFile, this.filteredDependencyFile);
                    FileReader in = new FileReader(this.filteredDependencyFile);
                    try {
                        PluginArtifactType pluginArtifactType = PluginXmlUtil.loadPluginArtifactMetadata((Reader)in);
                        PluginArtifactType removed = new PluginArtifactType();
                        for (DependencyType test : pluginArtifactType.getDependency()) {
                            boolean t1 = added.contains(test);
                            int s1 = added.size();
                            boolean t2 = added.remove(test);
                            int s2 = added.size();
                            if (t1 != t2) {
                                this.getLogger().warn("dependencies.contains: " + t1 + ", dependencies.remove(test): " + t2);
                            }
                            if (t1 == (s1 == s2)) {
                                this.getLogger().warn("dependencies.contains: " + t1 + ", size before: " + s1 + ", size after: " + s2);
                            }
                            if (t2) continue;
                            removed.getDependency().add(test);
                        }
                        if (!added.isEmpty() || !removed.getDependency().isEmpty()) {
                            this.saveDependencyChanges(added, removed);
                            if (this.overwriteChangedDependencies) {
                                this.writeDependencies(this.toPluginArtifactType(dependencies), this.dependencyFile);
                            }
                        }
                        break block13;
                    }
                    finally {
                        in.close();
                    }
                }
                this.writeDependencies(this.toPluginArtifactType(dependencies), this.dependencyFile);
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not read or write dependency history info", e);
            }
        }
    }

    protected void saveDependencyChanges(Collection<DependencyType> dependencies, PluginArtifactType removed) throws Exception {
        File addedFile = new File(this.filteredDependencyFile.getParentFile(), "dependencies.added.xml");
        PluginArtifactType added = this.toPluginArtifactType(dependencies);
        this.writeDependencies(added, addedFile);
        File removedFile = new File(this.filteredDependencyFile.getParentFile(), "dependencies.removed.xml");
        this.writeDependencies(removed, removedFile);
        File treeListing = this.saveTreeListing();
        StringWriter out = new StringWriter();
        out.write("Dependencies have changed:\n");
        if (!added.getDependency().isEmpty()) {
            out.write("\tAdded dependencies are saved here: " + addedFile.getAbsolutePath() + "\n");
            if (this.logDependencyChanges) {
                PluginXmlUtil.writePluginArtifact((PluginArtifactType)added, (Writer)out);
            }
        }
        if (!removed.getDependency().isEmpty()) {
            out.write("\tRemoved dependencies are saved here: " + removedFile.getAbsolutePath() + "\n");
            if (this.logDependencyChanges) {
                PluginXmlUtil.writePluginArtifact((PluginArtifactType)removed, (Writer)out);
            }
        }
        out.write("\tTree listing is saved here: " + treeListing.getAbsolutePath() + "\n");
        out.write("Delete " + this.dependencyFile.getAbsolutePath() + " if you are happy with the dependency changes.");
        if (!this.warnOnDependencyChange) {
            throw new MojoFailureException(out.toString());
        }
        this.getLog().warn((CharSequence)out.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveTreeListing() throws IOException {
        File treeListFile = new File(this.filteredDependencyFile.getParentFile(), "treeListing.txt");
        FileOutputStream os = new FileOutputStream(treeListFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        try {
            writer.write(this.treeListing);
        }
        finally {
            writer.close();
        }
        return treeListFile;
    }

    private PluginArtifactType toPluginArtifactType(Collection<DependencyType> dependencies) throws IOException, XMLStreamException, JAXBException {
        PluginArtifactType pluginArtifactType = new PluginArtifactType();
        for (DependencyType dependency : dependencies) {
            pluginArtifactType.getDependency().add(dependency);
        }
        return pluginArtifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDependencies(PluginArtifactType pluginArtifactType, File file) throws IOException, XMLStreamException, JAXBException {
        pluginArtifactType.setModuleId(this.getModuleId());
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        } else if (!parent.isDirectory()) {
            throw new IOException("expected dependencies history directory is not a directory: " + parent);
        }
        FileWriter out = new FileWriter(file);
        Collections.sort(pluginArtifactType.getDependency(), new Comparator<DependencyType>(){

            @Override
            public int compare(DependencyType a, DependencyType b) {
                int result = a.getGroupId().compareTo(b.getGroupId());
                if (result != 0) {
                    return result;
                }
                result = a.getArtifactId().compareTo(b.getArtifactId());
                if (result != 0) {
                    return result;
                }
                return this.getType(a).compareTo(this.getType(b));
            }

            private String getType(DependencyType a) {
                return a.getType() == null ? "jar" : a.getType();
            }
        });
        try {
            PluginXmlUtil.writePluginArtifact((PluginArtifactType)pluginArtifactType, (Writer)out);
        }
        finally {
            out.close();
        }
    }
}

