/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.kernel.osgi.ConfigurationActivator;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.ClasspathElement;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.system.osgi.BootActivator;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class ArchiveCarMojo
extends AbstractCarMojo {
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private JarArchiver jarArchiver = null;
    private ArchiverManager archiverManager = null;
    private File baseDirectory = null;
    private File outputDirectory = null;
    private File classesDirectory = null;
    private String finalName = null;
    private File targetRepository = null;
    private File explicitResolutionProperties = null;
    private ClasspathElement[] classpath = null;
    private String classpathPrefix = null;
    private File resourcesDir;
    private boolean boot;
    private Map instructions;
    private Dependency module = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getDependencies(this.project, false);
        File archive = this.createArchive();
        this.project.getArtifact().setFile(archive);
    }

    private File getArtifactInRepositoryDir() {
        String groupId = this.project.getGroupId().replace('.', '/');
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        String type = "car";
        if (this.module != null && this.module.getType() != null && this.module.getType().equals("eba")) {
            groupId = "application";
            artifactId = this.module.getArtifactId();
            version = this.module.getVersion();
            type = "eba";
        }
        File dir = new File(this.targetRepository, groupId);
        dir = new File(dir, artifactId);
        dir = new File(dir, version);
        dir = new File(dir, artifactId + "-" + version + "." + type);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createArchive() throws MojoExecutionException {
        File archiveFile = ArchiveCarMojo.getArchiveFile(this.outputDirectory, this.finalName, null);
        GeronimoArchiver archiver = new GeronimoArchiver(this.archiverManager);
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            File artifactDirectory = this.getArtifactInRepositoryDir();
            if (artifactDirectory.exists()) {
                archiver.getArchiver().addDirectory(artifactDirectory);
            }
            if (this.classesDirectory.isDirectory()) {
                archiver.getArchiver().addDirectory(this.classesDirectory);
            }
            if (this.resourcesDir.isDirectory()) {
                archiver.getArchiver().addDirectory(this.resourcesDir);
            }
            String[] includes = new String[]{"LICENSE.txt", "LICENSE", "NOTICE.txt", "NOTICE", "DISCLAIMER.txt", "DISCLAIMER"};
            archiver.getArchiver().addDirectory(this.baseDirectory, "META-INF/", includes, new String[0]);
            if (artifactDirectory.exists()) {
                File mfFile = new File(artifactDirectory, "META-INF/MANIFEST.MF");
                if (mfFile.exists()) {
                    JarArchiver.FilesetManifestConfig mergeFilesetManifestConfig = new JarArchiver.FilesetManifestConfig();
                    mergeFilesetManifestConfig.setValue("merge");
                    archiver.getArchiver().setFilesetmanifest(mergeFilesetManifestConfig);
                } else {
                    File importsTxtFile = new File(artifactDirectory, "META-INF/imports.txt");
                    if (importsTxtFile.exists()) {
                        StringBuilder imports = new StringBuilder("org.apache.geronimo.kernel.osgi,");
                        if (this.boot) {
                            this.archive.addManifestEntry((Object)"Bundle-Activator", (Object)BootActivator.class.getName());
                            imports.append("org.apache.geronimo.system.osgi,");
                        } else {
                            this.archive.addManifestEntry((Object)"Bundle-Activator", (Object)ConfigurationActivator.class.getName());
                        }
                        this.archive.addManifestEntry((Object)"Bundle-Name", (Object)this.project.getName());
                        this.archive.addManifestEntry((Object)"Bundle-Vendor", (Object)this.project.getOrganization().getName());
                        ArtifactVersion version = this.project.getArtifact().getSelectedVersion();
                        String versionString = "" + version.getMajorVersion() + "." + version.getMinorVersion() + "." + version.getIncrementalVersion();
                        if (version.getQualifier() != null) {
                            versionString = versionString + "." + version.getQualifier();
                        }
                        this.archive.addManifestEntry((Object)"Bundle-Version", (Object)versionString);
                        this.archive.addManifestEntry((Object)"Bundle-ManifestVersion", (Object)"2");
                        this.archive.addManifestEntry((Object)"Bundle-Description", (Object)this.project.getDescription());
                        this.archive.addManifestEntry((Object)"Bundle-License", (Object)((License)this.project.getLicenses().get(0)).getUrl());
                        this.archive.addManifestEntry((Object)"Bundle-DocURL", (Object)this.project.getUrl());
                        this.archive.addManifestEntry((Object)"Bundle-SymbolicName", (Object)(this.project.getGroupId() + "." + this.project.getArtifactId()));
                        InputStreamReader in = new InputStreamReader(new FileInputStream(importsTxtFile));
                        char[] buf = new char[1024];
                        try {
                            int i;
                            while ((i = in.read(buf)) > 0) {
                                imports.append(buf, 0, i);
                            }
                        }
                        finally {
                            ((Reader)in).close();
                        }
                        if (this.instructions != null) {
                            String requiredBundles;
                            String explicitImports = (String)this.instructions.get("Import-Package");
                            if (explicitImports != null) {
                                explicitImports = explicitImports.replaceAll("[\r\n]", "");
                                imports.append(',');
                                imports.append(explicitImports);
                            }
                            if ((requiredBundles = (String)this.instructions.get("Require-Bundle")) != null) {
                                requiredBundles = requiredBundles.replaceAll("[\r\n]", "");
                                this.archive.addManifestEntry((Object)"Require-Bundle", (Object)requiredBundles);
                            }
                        }
                        this.archive.addManifestEntry((Object)"Import-Package", (Object)imports.toString());
                        this.archive.addManifestEntry((Object)"DynamicImport-Package", (Object)"*");
                    }
                }
            }
            if (this.classpath != null) {
                this.archive.addManifestEntry((Object)"Class-Path", (Object)this.getClassPath());
            }
            archiver.createArchive(this.project, this.archive);
            File file = archiveFile;
            return file;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create archive", e);
        }
        finally {
            archiver.cleanup();
        }
    }

    private String getClassPath() throws MojoExecutionException {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.classpath.length; ++i) {
            String entry = this.classpath[i].getEntry();
            if (entry != null) {
                buff.append(entry);
            } else {
                Artifact artifact = this.resolveArtifact(this.classpath[i].getGroupId(), this.classpath[i].getArtifactId(), this.classpath[i].getType());
                if (artifact == null) {
                    throw new MojoExecutionException("Could not resolve classpath item: " + this.classpath[i]);
                }
                String prefix = this.classpath[i].getClasspathPrefix();
                if (prefix == null) {
                    prefix = this.classpathPrefix;
                }
                if (prefix != null) {
                    buff.append(prefix);
                    if (!prefix.endsWith("/")) {
                        buff.append("/");
                    }
                }
                String path = this.getArtifactRepository().pathOf(artifact);
                buff.append(path);
            }
            if (i + 1 >= this.classpath.length) continue;
            buff.append(" ");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Using classpath: " + buff));
        }
        return buff.toString();
    }

    private static class GeronimoArchiver
    extends MavenArchiver {
        private ArchiverManager archiverManager;
        private List<File> tmpDirs = new ArrayList<File>();

        public GeronimoArchiver(ArchiverManager archiverManager) {
            this.archiverManager = archiverManager;
        }

        public void addArchivedFileSet(File archiveFile) throws ArchiverException {
            UnArchiver unArchiver;
            try {
                unArchiver = this.archiverManager.getUnArchiver(archiveFile);
            }
            catch (NoSuchArchiverException e) {
                throw new ArchiverException("Error adding archived file-set. UnArchiver not found for: " + archiveFile, (Throwable)e);
            }
            File tempDir = FileUtils.createTempFile((String)"archived-file-set.", (String)".tmp", null);
            tempDir.mkdirs();
            this.tmpDirs.add(tempDir);
            unArchiver.setSourceFile(archiveFile);
            unArchiver.setDestDirectory(tempDir);
            try {
                unArchiver.extract();
            }
            catch (IOException e) {
                throw new ArchiverException("Error adding archived file-set. Failed to extract: " + archiveFile, (Throwable)e);
            }
            this.getArchiver().addDirectory(tempDir, null, null, null);
        }

        public void cleanup() {
            for (File dir : this.tmpDirs) {
                try {
                    FileUtils.deleteDirectory((File)dir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.tmpDirs.clear();
        }
    }
}

