/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.ImportType;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractCarMojo
extends AbstractLogEnabled
implements Mojo {
    private Log log;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected File basedir;
    protected Set<org.apache.maven.artifact.Artifact> dependencyArtifacts;
    protected Set<org.apache.maven.artifact.Artifact> localDependencies;
    private ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    protected String treeListing;
    protected String encoding;
    protected MavenResourcesFiltering mavenResourcesFiltering;
    protected MavenSession session;
    protected String escapeString = "\\";
    protected MavenFileFilter mavenFileFilter;
    protected Map<String, String> systemProperties;
    private Map<String, String> previousSystemProperties;
    protected ArtifactRepository artifactRepository = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateExplicitVersionProperties(File outputFile, Set<org.apache.maven.artifact.Artifact> dependencies) throws MojoExecutionException, IOException {
        this.getLog().debug((CharSequence)("Generating explicit version properties: " + outputFile));
        Properties props = new Properties();
        for (org.apache.maven.artifact.Artifact artifact : dependencies) {
            String name = artifact.getGroupId() + "/" + artifact.getArtifactId() + "//" + artifact.getType();
            String value = artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getType();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setting " + name + "=" + value));
            }
            props.setProperty(name, value);
        }
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(outputFile));
            props.store(output, null);
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".car");
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.artifact.Artifact artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.model.Dependency artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected org.apache.maven.artifact.Artifact geronimoToMavenArtifact(Artifact artifact) throws MojoExecutionException {
        assert (artifact != null);
        return this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString(), artifact.getType(), null);
    }

    protected boolean isModuleArtifact(Artifact artifact) {
        assert (artifact != null);
        return "car".equals(artifact.getType());
    }

    protected boolean includeDependency(org.apache.maven.model.Dependency dependency) {
        if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis")) {
            return false;
        }
        String scope = dependency.getScope();
        return scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope);
    }

    protected org.apache.maven.model.Dependency resolveDependency(org.apache.maven.model.Dependency dependency, List<org.apache.maven.model.Dependency> artifacts) {
        for (org.apache.maven.model.Dependency match : artifacts) {
            if (!this.matches(dependency, match)) continue;
            return match;
        }
        throw new IllegalStateException("Dependency " + dependency + " is not resolved in project");
    }

    private boolean matches(org.apache.maven.model.Dependency dependency, org.apache.maven.model.Dependency match) {
        if (dependency.getGroupId() != null && !dependency.getGroupId().equals(match.getGroupId())) {
            return false;
        }
        if (dependency.getArtifactId() != null && !dependency.getArtifactId().equals(match.getArtifactId())) {
            return false;
        }
        return dependency.getType() == null || dependency.getType().equals(match.getType());
    }

    protected void getDependencies(MavenProject project, boolean useTransitiveDependencies) throws MojoExecutionException {
        DependencyNode rootNode;
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener(this.getLogger());
        try {
            Map managedVersions = project.getManagedVersionMap();
            Set dependencyArtifacts = project.getDependencyArtifacts();
            if (dependencyArtifacts == null) {
                dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            }
            ArtifactResolutionResult result = this.artifactCollector.collect(dependencyArtifacts, project.getArtifact(), managedVersions, this.localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
            this.dependencyArtifacts = result.getArtifacts();
            rootNode = listener.getRootNode();
        }
        catch (ArtifactResolutionException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Invalid dependency version for artifact " + project.getArtifact());
        }
        Scanner scanner = new Scanner();
        scanner.scan(rootNode, useTransitiveDependencies);
        this.localDependencies = scanner.localDependencies.keySet();
        this.treeListing = scanner.getLog();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }

    protected static org.apache.geronimo.kernel.repository.Dependency toGeronimoDependency(org.apache.maven.artifact.Artifact dependency, boolean includeVersion) {
        Artifact artifact = AbstractCarMojo.toGeronimoArtifact(dependency, includeVersion);
        return new org.apache.geronimo.kernel.repository.Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.ALL);
    }

    private static Artifact toGeronimoArtifact(org.apache.maven.artifact.Artifact dependency, boolean includeVersion) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = includeVersion ? dependency.getVersion() : null;
        String type = dependency.getType();
        return new Artifact(groupId, artifactId, version, type);
    }

    protected LinkedHashSet<DependencyType> toDependencies(List<Dependency> explicitDependencies, UseMavenDependencies useMavenDependencies, boolean includeImport) throws InvalidDependencyVersionException, ArtifactResolutionException, ProjectBuildingException, MojoExecutionException {
        ArrayList<DependencyType> dependencyTypes = new ArrayList<DependencyType>();
        for (Dependency dependency : explicitDependencies) {
            dependencyTypes.add(dependency.toDependencyType());
        }
        LinkedHashSet<DependencyType> dependencies = new LinkedHashSet<DependencyType>();
        if (useMavenDependencies == null || !useMavenDependencies.isValue()) {
            dependencies.addAll(dependencyTypes);
            this.localDependencies = new HashSet<org.apache.maven.artifact.Artifact>();
            for (DependencyType dependency : dependencies) {
                this.localDependencies.add(this.geronimoToMavenArtifact(dependency.toArtifact()));
            }
        } else {
            HashMap<String, DependencyType> explicitDependencyMap = new HashMap<String, DependencyType>();
            for (DependencyType dependency : dependencyTypes) {
                explicitDependencyMap.put(AbstractCarMojo.getKey(dependency), dependency);
            }
            this.getDependencies(this.project, useMavenDependencies.isUseTransitiveDependencies());
            for (org.apache.maven.artifact.Artifact entry : this.localDependencies) {
                dependencies.add(this.toDependencyType(entry, explicitDependencyMap, useMavenDependencies.isIncludeVersion(), includeImport));
            }
        }
        return dependencies;
    }

    DependencyType toDependencyType(org.apache.maven.artifact.Artifact artifact, Map<String, DependencyType> explicitDependencyMap, boolean includeVersion, boolean includeImport) {
        DependencyType explicitDependency = explicitDependencyMap.get(AbstractCarMojo.getKey(artifact));
        DependencyType dependency = this.toDependencyType(artifact, includeVersion, explicitDependency, includeImport);
        return dependency;
    }

    DependencyType toDependencyType(org.apache.maven.artifact.Artifact artifact, boolean includeVersion, DependencyType explicitDependency, boolean includeImport) {
        DependencyType dependency = new DependencyType();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        String version = null;
        if (includeVersion) {
            version = artifact.getVersionRange() == null ? artifact.getVersion() : artifact.getVersionRange().getRecommendedVersion().toString();
        }
        dependency.setVersion(version);
        dependency.setType(artifact.getType());
        if (includeImport) {
            ImportType importType = ImportType.ALL;
            if (explicitDependency != null && explicitDependency.getImport() != null) {
                importType = explicitDependency.getImport();
            }
            dependency.setImport(importType);
        }
        if (explicitDependency != null) {
            dependency.setStart(Boolean.valueOf(explicitDependency.isStart()));
        }
        return dependency;
    }

    private static String getKey(DependencyType dependency) {
        return dependency.getGroupId() + "/" + dependency.getArtifactId() + "/" + dependency.getType();
    }

    private static String getKey(org.apache.maven.artifact.Artifact dependency) {
        return dependency.getGroupId() + "/" + dependency.getArtifactId() + "/" + dependency.getType();
    }

    protected ArtifactType getModuleId() {
        ArtifactType artifactType = new ArtifactType();
        artifactType.setGroupId(this.project.getGroupId());
        artifactType.setArtifactId(this.project.getArtifactId());
        artifactType.setVersion(this.project.getVersion());
        artifactType.setType(this.project.getArtifact().getType());
        return artifactType;
    }

    protected void cleanup() {
        this.unsetSystemProperties(this.previousSystemProperties);
    }

    protected Map<String, String> setSystemProperties() {
        if (this.previousSystemProperties != null) {
            throw new IllegalStateException("setSystemProperties called twice");
        }
        if (this.systemProperties == null) {
            return Collections.emptyMap();
        }
        this.getLog().debug((CharSequence)("Setting system properties: " + this.systemProperties));
        this.previousSystemProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String oldValue = System.setProperty(key, value);
            this.previousSystemProperties.put(key, oldValue);
        }
        return this.previousSystemProperties;
    }

    protected void unsetSystemProperties(Map<String, String> previousSystemProperties) {
        if (previousSystemProperties != null) {
            for (Map.Entry<String, String> entry : previousSystemProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) {
                    System.clearProperty(key);
                    continue;
                }
                System.setProperty(key, value);
            }
        }
    }

    protected org.apache.maven.artifact.Artifact resolveArtifact(String groupId, String artifactId, String type) {
        for (org.apache.maven.artifact.Artifact artifact : this.dependencyArtifacts) {
            if (!this.matches(groupId, artifactId, type, artifact)) continue;
            return artifact;
        }
        return null;
    }

    private boolean matches(String groupId, String artifactId, String type, org.apache.maven.artifact.Artifact artifact) {
        if (!groupId.equals(artifact.getGroupId())) {
            return false;
        }
        if (!artifactId.equals(artifact.getArtifactId())) {
            return false;
        }
        return type.equals(artifact.getType());
    }

    protected void filter(File sourceFile, File targetFile) throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            targetFile.getParentFile().mkdirs();
            List filters = this.mavenFileFilter.getDefaultFilterWrappers(this.project, null, true, this.session, null);
            this.mavenFileFilter.copyFile(sourceFile, targetFile, true, filters, this.encoding, true);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void setLoggingLevel() {
        if (System.getProperty("org.ops4j.pax.logging.DefaultServiceLog.level") == null) {
            System.setProperty("org.ops4j.pax.logging.DefaultServiceLog.level", this.log.isDebugEnabled() ? "DEBUG" : "INFO");
        }
    }

    protected Framework getFramework(String extraPackages) throws BundleException {
        this.setLoggingLevel();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.osgi.framework.system.packages", "org.osgi.framework; version=1.6.0,org.osgi.framework.launch; version=1.0.0,org.osgi.framework.startlevel; version=1.0.0,org.osgi.framework.wiring; version=1.0.0,org.osgi.framework.hooks.service; version=1.1.0,org.osgi.framework.hooks.bundle; version=1.0.0,org.osgi.framework.hooks.resolver; version=1.0.0,org.osgi.framework.hooks.weaving; version=1.0.0,org.osgi.service.packageadmin; version=1.2.0,org.osgi.service.startlevel; version=1.1.0,org.osgi.service.url; version=1.0.0,org.osgi.util.tracker; version=1.5.0,javax.accessibility,javax.annotation.processing,javax.activity,javax.crypto,javax.crypto.interfaces,javax.crypto.spec,javax.imageio,javax.imageio.event,javax.imageio.metadata,javax.imageio.plugins.bmp,javax.imageio.plugins.jpeg,javax.imageio.spi,javax.imageio.stream,javax.jws;version=2.0,javax.jws.soap;version=2.0,javax.lang.model,javax.lang.model.element,javax.lang.model.type,javax.lang.model.util,javax.management,javax.management.loading,javax.management.modelmbean,javax.management.monitor,javax.management.openmbean,javax.management.relation,javax.management.remote,javax.management.remote.rmi,javax.management.timer,javax.naming,javax.naming.directory,javax.naming.event,javax.naming.ldap,javax.naming.spi,javax.net,javax.net.ssl,javax.print,javax.print.attribute,javax.print.attribute.standard,javax.print.event,javax.rmi,javax.rmi.CORBA,javax.rmi.ssl,javax.script,javax.security.auth,javax.security.auth.callback,javax.security.auth.kerberos,javax.security.auth.login,javax.security.auth.spi,javax.security.auth.x500,javax.security.cert,javax.security.sasl,javax.sound.midi,javax.sound.midi.spi,javax.sound.sampled,javax.sound.sampled.spi,javax.sql,javax.sql.rowset,javax.sql.rowset.serial,javax.sql.rowset.spi,javax.swing,javax.swing.border,javax.swing.colorchooser,javax.swing.event,javax.swing.filechooser,javax.swing.plaf,javax.swing.plaf.basic,javax.swing.plaf.metal,javax.swing.plaf.multi,javax.swing.plaf.synth,javax.swing.table,javax.swing.text,javax.swing.text.html,javax.swing.text.html.parser,javax.swing.text.rtf,javax.swing.tree,javax.swing.undo,javax.tools,javax.transaction;javax.transaction.xa;version=1.1;partial=true;mandatory:=partial,javax.xml,javax.xml.namespace;version=1.0,javax.xml.crypto,javax.xml.crypto.dom,javax.xml.crypto.dsig,javax.xml.crypto.dsig.dom,javax.xml.crypto.dsig.keyinfo,javax.xml.crypto.dsig.spec,javax.xml.datatype,javax.xml.parsers,javax.xml.transform,javax.xml.transform.dom,javax.xml.transform.sax,javax.xml.transform.stax,javax.xml.transform.stream,javax.xml.validation,javax.xml.xpath,org.ietf.jgss,org.omg.CORBA,org.omg.CORBA_2_3,org.omg.CORBA_2_3.portable,org.omg.CORBA.DynAnyPackage,org.omg.CORBA.ORBPackage,org.omg.CORBA.portable,org.omg.CORBA.TypeCodePackage,org.omg.CosNaming,org.omg.CosNaming.NamingContextExtPackage,org.omg.CosNaming.NamingContextPackage,org.omg.Dynamic,org.omg.DynamicAny,org.omg.DynamicAny.DynAnyFactoryPackage,org.omg.DynamicAny.DynAnyPackage,org.omg.IOP,org.omg.IOP.CodecFactoryPackage,org.omg.IOP.CodecPackage,org.omg.Messaging,org.omg.PortableInterceptor,org.omg.PortableInterceptor.ORBInitInfoPackage,org.omg.PortableServer,org.omg.PortableServer.CurrentPackage,org.omg.PortableServer.POAManagerPackage,org.omg.PortableServer.POAPackage,org.omg.PortableServer.portable,org.omg.PortableServer.ServantLocatorPackage,org.omg.SendingContext,org.omg.stub.java.rmi,org.omg.stub.javax.management.remote.rmi,org.w3c.dom,org.w3c.dom.bootstrap,org.w3c.dom.css,org.w3c.dom.events,org.w3c.dom.html,org.w3c.dom.ls,org.w3c.dom.ranges,org.w3c.dom.stylesheets,org.w3c.dom.traversal,org.w3c.dom.views,org.w3c.dom.xpath,org.xml.sax,org.xml.sax.ext,org.xml.sax.helpers");
        properties.put("org.osgi.framework.system.packages.extra", "net.sf.cglib.asm,net.sf.cglib.core,net.sf.cglib.proxy,net.sf.cglib.reflect,sun.misc,sun.reflect,org.apache.commons.jexl;version=\"1.1\",org.apache.commons.jexl.context;version=\"1.1\",org.apache.commons.jexl.resolver;version=\"1.1\",org.apache.geronimo.main,org.apache.geronimo.cli,org.apache.geronimo.cli.client,org.apache.geronimo.cli.daemon,org.apache.geronimo.common,org.apache.geronimo.common.propertyeditor,org.apache.geronimo.crypto,org.apache.geronimo.gbean,org.apache.geronimo.gbean.annotation,org.apache.geronimo.gbean.runtime,org.apache.geronimo.kernel,org.apache.geronimo.kernel.basic,org.apache.geronimo.kernel.classloader,org.apache.geronimo.kernel.config,org.apache.geronimo.kernel.config.xstream,org.apache.geronimo.kernel.lifecycle,org.apache.geronimo.kernel.management,org.apache.geronimo.kernel.osgi,org.apache.geronimo.kernel.proxy,org.apache.geronimo.kernel.repository,org.apache.geronimo.kernel.rmi,org.apache.geronimo.kernel.util,org.apache.geronimo.system.configuration,org.apache.geronimo.system.configuration.cli,org.apache.geronimo.system.configuration.condition,org.apache.geronimo.system.jmx,org.apache.geronimo.system.logging,org.apache.geronimo.system.logging.log4j,org.apache.geronimo.system.main,org.apache.geronimo.system.plugin,org.apache.geronimo.system.plugin.model,org.apache.geronimo.system.properties,org.apache.geronimo.system.repository,org.apache.geronimo.system.resolver,org.apache.geronimo.system.serverinfo,org.apache.geronimo.system.threads,org.apache.geronimo.system.util,org.apache.geronimo.transformer,org.apache.geronimo.mavenplugins.car,org.apache.karaf.jaas.boot;version=\"2.2.1\",org.apache.yoko,org.apache.yoko.osgi,org.apache.yoko.rmispec.util,org.apache.geronimo.hook" + extraPackages);
        properties.put("org.osgi.framework.bootdelegation", "sun.*,com.sun.*");
        File storageDir = new File(this.basedir, "target/bundle-cache");
        properties.put("org.osgi.framework.storage", storageDir.getAbsolutePath());
        if (this.log.isDebugEnabled()) {
            properties.put("felix.log.level", "4");
        }
        AbstractCarMojo.resetFrameworkProperties();
        ServiceLoader<FrameworkFactory> loader = ServiceLoader.load(FrameworkFactory.class);
        Framework framework = loader.iterator().next().newFramework(properties);
        framework.start();
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        this.systemProperties.put("geronimo.build.car", "true");
        if (null == System.getProperty("openejb.log.factory")) {
            this.systemProperties.put("openejb.log.factory", "org.apache.openejb.util.PaxLogStreamFactory");
        }
        this.systemProperties.put("karaf.startLocalConsole", "false");
        this.systemProperties.put("openejb.geronimo", "true");
        this.setSystemProperties();
        return framework;
    }

    private static void resetFrameworkProperties() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkProperties");
            Field f = clazz.getDeclaredField("properties");
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected class ArtifactLookupImpl
    implements Maven2RepositoryAdapter.ArtifactLookup {
        protected ArtifactLookupImpl() {
        }

        @Override
        public File getBasedir() {
            String path = AbstractCarMojo.this.getArtifactRepository().getBasedir();
            return new File(path);
        }

        private boolean isProjectArtifact(Artifact artifact) {
            MavenProject project = AbstractCarMojo.this.getProject();
            return artifact.getGroupId().equals(project.getGroupId()) && artifact.getArtifactId().equals(project.getArtifactId());
        }

        @Override
        public File getLocation(Artifact artifact) {
            org.apache.maven.artifact.Artifact mavenArtifact;
            assert (artifact != null);
            if (this.isProjectArtifact(artifact) && artifact.getVersion() == null) {
                throw new IllegalStateException("WTF? project has no version??");
            }
            if (artifact.getVersion() == null) {
                if (AbstractCarMojo.this.log.isDebugEnabled()) {
                    AbstractCarMojo.this.getLog().debug((CharSequence)("Resolving artifact: " + artifact));
                }
                mavenArtifact = AbstractCarMojo.this.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType());
            } else {
                mavenArtifact = AbstractCarMojo.this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString(), artifact.getType(), null);
            }
            String path = AbstractCarMojo.this.getArtifactRepository().pathOf(mavenArtifact);
            return new File(this.getBasedir(), path);
        }
    }

    private static class Scanner {
        private final Map<org.apache.maven.artifact.Artifact, Set<org.apache.maven.artifact.Artifact>> localDependencies = new LinkedHashMap<org.apache.maven.artifact.Artifact, Set<org.apache.maven.artifact.Artifact>>();
        private final Set<org.apache.maven.artifact.Artifact> carDependencies = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        private final StringBuilder log = new StringBuilder();

        private Scanner() {
        }

        public void scan(DependencyNode rootNode, boolean useTransitiveDependencies) {
            LinkedHashSet<org.apache.maven.artifact.Artifact> children = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
            for (DependencyNode child : rootNode.getChildren()) {
                this.scan(child, Accept.ACCEPT, useTransitiveDependencies, false, "", children);
            }
            if (useTransitiveDependencies) {
                this.localDependencies.keySet().removeAll(this.carDependencies);
            }
        }

        private void scan(DependencyNode rootNode, Accept parentAccept, boolean useTransitiveDependencies, boolean isFromCar, String indent, Set<org.apache.maven.artifact.Artifact> parentsChildren) {
            org.apache.maven.artifact.Artifact artifact = this.getArtifact(rootNode);
            Accept accept = this.accept(artifact, parentAccept);
            if (accept.isContinue()) {
                Set<org.apache.maven.artifact.Artifact> children = this.localDependencies.get(artifact);
                if (isFromCar) {
                    if (!artifact.getType().equals("car")) {
                        this.log.append(indent).append("from car:").append(artifact).append("\n");
                        this.carDependencies.add(artifact);
                    } else {
                        this.log.append(indent).append("is car:").append(artifact).append("\n");
                    }
                } else {
                    this.log.append(indent).append("local:").append(artifact).append("\n");
                    if (this.carDependencies.contains(artifact)) {
                        this.log.append(indent).append("already in car, returning:").append(artifact).append("\n");
                        parentsChildren.add(artifact);
                        return;
                    }
                    parentsChildren.add(artifact);
                    if (children == null) {
                        children = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
                        this.localDependencies.put(artifact, children);
                    }
                    if (artifact.getType().equals("car") || !useTransitiveDependencies) {
                        isFromCar = true;
                    }
                }
                for (DependencyNode child : rootNode.getChildren()) {
                    this.scan(child, accept, useTransitiveDependencies, isFromCar, indent + "  ", children);
                }
            }
        }

        public String getLog() {
            return this.log.toString();
        }

        private org.apache.maven.artifact.Artifact getArtifact(DependencyNode rootNode) {
            org.apache.maven.artifact.Artifact artifact = rootNode.getArtifact();
            if (rootNode.getRelatedArtifact() != null) {
                artifact = rootNode.getRelatedArtifact();
            }
            return artifact;
        }

        private Accept accept(org.apache.maven.artifact.Artifact dependency, Accept previous) {
            if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis")) {
                return Accept.STOP;
            }
            String scope = dependency.getScope();
            if (scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope)) {
                return previous;
            }
            return Accept.STOP;
        }

        private static enum Accept {
            ACCEPT(true, true),
            PROVIDED(true, false),
            STOP(false, false);

            private final boolean more;
            private final boolean local;

            private Accept(boolean more, boolean local) {
                this.more = more;
                this.local = local;
            }

            public boolean isContinue() {
                return this.more;
            }

            public boolean isLocal() {
                return this.local;
            }
        }
    }
}

