/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.deployment.PluginBootstrap2;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.KernelConfigurationManager;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.RecordingLifecycleMonitor;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.geronimo.mavenplugins.car.MavenAttributeStore;
import org.apache.geronimo.mavenplugins.car.MavenConfigStore;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.geronimo.system.resolver.ExplicitDefaultArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class PackageMojo
extends AbstractCarMojo {
    private File outputDirectory = null;
    private File repository = null;
    private File targetRepository = null;
    private String defaultDeploymentConfig = null;
    private String[] deploymentConfigs;
    private String deployerName = null;
    private File planFile = null;
    private File moduleFile = null;
    private Dependency module = null;
    private File explicitResolutionProperties = null;
    private boolean bootstrap = false;
    private static ThreadLocal<Maven2RepositoryAdapter.ArtifactLookup> lookupHolder = new ThreadLocal();
    private static final String KERNEL_NAME = "geronimo.maven";
    private Kernel kernel;
    private AbstractName targetConfigStoreAName;
    private AbstractName targetRepositoryAName;
    private boolean targetSet;
    private static final String[] DEPLOY_SIGNATURE = new String[]{Boolean.TYPE.getName(), File.class.getName(), File.class.getName(), File.class.getName(), Boolean.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            FileUtils.forceDelete((File)this.targetRepository);
            FileUtils.forceMkdir((File)this.targetRepository);
            if (!this.planFile.exists()) {
                return;
            }
            if (this.deploymentConfigs == null) {
                this.deploymentConfigs = !this.bootstrap ? new String[]{this.defaultDeploymentConfig} : new String[0];
            }
            this.getLog().debug((CharSequence)("Deployment configs: " + Arrays.asList(this.deploymentConfigs)));
            this.getDependencies(this.project, false);
            if (this.module != null) {
                org.apache.maven.artifact.Artifact artifact = this.resolveArtifact(this.module.getGroupId(), this.module.getArtifactId(), this.module.getType());
                if (artifact == null) {
                    throw new MojoExecutionException("Could not resolve module " + this.module.getGroupId() + ":" + this.module.getArtifactId() + ":" + this.module.getType() + ". Perhaps it is not listed as a dependency");
                }
                this.moduleFile = artifact.getFile();
                this.getLog().debug((CharSequence)("Using module file: " + this.moduleFile));
            }
            this.generateExplicitVersionProperties(this.explicitResolutionProperties, this.dependencies);
            lookupHolder.set(new AbstractCarMojo.ArtifactLookupImpl());
            if (this.bootstrap) {
                this.executeBootShell();
            } else {
                this.buildPackage();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("could not package plugin", e);
        }
    }

    private File getArtifactInRepositoryDir() {
        File dir = new File(this.targetRepository, this.project.getGroupId().replace('.', '/'));
        dir = new File(dir, this.project.getArtifactId());
        dir = new File(dir, this.project.getVersion());
        dir = new File(dir, this.project.getArtifactId() + "-" + this.project.getVersion() + ".car");
        return dir;
    }

    public void executeBootShell() throws Exception {
        this.getLog().debug((CharSequence)"Starting bootstrap shell...");
        PluginBootstrap2 boot = new PluginBootstrap2();
        boot.setBuildDir(this.outputDirectory);
        boot.setCarFile(this.getArtifactInRepositoryDir());
        boot.setLocalRepo(this.repository);
        boot.setPlan(this.planFile);
        boot.setExpanded(true);
        boot.bootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPackage() throws Exception {
        this.getLog().info((CharSequence)("Packaging module configuration: " + this.planFile));
        Kernel kernel = this.createKernel();
        if (!this.targetSet) {
            kernel.stopGBean(this.targetRepositoryAName);
            kernel.setAttribute(this.targetRepositoryAName, "root", (Object)this.targetRepository.toURI());
            kernel.startGBean(this.targetRepositoryAName);
            if (kernel.getGBeanState(this.targetConfigStoreAName) != 1) {
                throw new IllegalStateException("After restarted repository then config store is not running");
            }
            this.targetSet = true;
        }
        this.getLog().debug((CharSequence)("Starting configurations..." + Arrays.asList(this.deploymentConfigs)));
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        try {
            for (String artifactName : this.deploymentConfigs) {
                Artifact configName = Artifact.create((String)artifactName);
                if (configurationManager.isLoaded(configName)) continue;
                RecordingLifecycleMonitor monitor = new RecordingLifecycleMonitor();
                try {
                    configurationManager.loadConfiguration(configName, (LifecycleMonitor)monitor);
                }
                catch (LifecycleException e) {
                    this.getLog().error((CharSequence)("Could not load deployer configuration: " + configName + "\n" + monitor.toString()), (Throwable)e);
                }
                monitor = new RecordingLifecycleMonitor();
                try {
                    configurationManager.startConfiguration(configName, (LifecycleMonitor)monitor);
                    this.getLog().info((CharSequence)("Started deployer: " + configName));
                }
                catch (LifecycleException e) {
                    this.getLog().error((CharSequence)("Could not start deployer configuration: " + configName + "\n" + monitor.toString()), (Throwable)e);
                }
            }
        }
        finally {
            ConfigurationUtil.releaseConfigurationManager((Kernel)kernel, (ConfigurationManager)configurationManager);
        }
        this.getLog().debug((CharSequence)"Deploying...");
        AbstractName deployer = this.locateDeployer(kernel);
        this.invokeDeployer(kernel, deployer, this.targetConfigStoreAName.toString());
        kernel.shutdown();
        kernel = null;
    }

    private synchronized Kernel createKernel() throws Exception {
        if (this.kernel != null) {
            return this.kernel;
        }
        this.getLog().debug((CharSequence)"Creating kernel...");
        this.kernel = KernelRegistry.getKernel((String)KERNEL_NAME);
        if (this.kernel != null) {
            return this.kernel;
        }
        this.kernel = KernelFactory.newInstance().createKernel(KERNEL_NAME);
        this.kernel.boot();
        this.bootDeployerSystem();
        return this.kernel;
    }

    private void bootDeployerSystem() throws Exception {
        this.getLog().debug((CharSequence)"Booting deployer system...");
        Artifact baseId = new Artifact("geronimo", "packaging", "fixed", "car");
        Naming naming = this.kernel.getNaming();
        ConfigurationData bootstrap = new ConfigurationData(baseId, naming);
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        HashSet<AbstractName> repoNames = new HashSet<AbstractName>();
        GBeanData repoGBean = bootstrap.addGBean("SourceRepository", GBeanInfo.getGBeanInfo((String)Maven2RepositoryAdapter.class.getName(), (ClassLoader)cl));
        Maven2RepositoryAdapter.ArtifactLookup lookup = new Maven2RepositoryAdapter.ArtifactLookup(){

            private Maven2RepositoryAdapter.ArtifactLookup getDelegate() {
                return (Maven2RepositoryAdapter.ArtifactLookup)lookupHolder.get();
            }

            public File getBasedir() {
                return this.getDelegate().getBasedir();
            }

            public File getLocation(Artifact artifact) {
                return this.getDelegate().getLocation(artifact);
            }
        };
        repoGBean.setAttribute("lookup", (Object)lookup);
        repoGBean.setAttribute("dependencies", (Object)this.dependencies);
        repoNames.add(repoGBean.getAbstractName());
        GBeanData targetRepoGBean = bootstrap.addGBean("TargetRepository", GBeanInfo.getGBeanInfo((String)Maven2Repository.class.getName(), (ClassLoader)cl));
        URI targetRepositoryURI = this.targetRepository.toURI();
        targetRepoGBean.setAttribute("root", (Object)targetRepositoryURI);
        repoNames.add(targetRepoGBean.getAbstractName());
        this.targetRepositoryAName = targetRepoGBean.getAbstractName();
        GBeanData artifactManagerGBean = bootstrap.addGBean("ArtifactManager", DefaultArtifactManager.GBEAN_INFO);
        GBeanData artifactResolverGBean = bootstrap.addGBean("ArtifactResolver", ExplicitDefaultArtifactResolver.GBEAN_INFO);
        artifactResolverGBean.setAttribute("versionMapLocation", (Object)this.explicitResolutionProperties.getAbsolutePath());
        ReferencePatterns repoPatterns = new ReferencePatterns(repoNames);
        artifactResolverGBean.setReferencePatterns("Repositories", repoPatterns);
        artifactResolverGBean.setReferencePattern("ArtifactManager", artifactManagerGBean.getAbstractName());
        HashSet<AbstractName> storeNames = new HashSet<AbstractName>();
        GBeanInfo configStoreInfo = GBeanInfo.getGBeanInfo((String)MavenConfigStore.class.getName(), (ClassLoader)cl);
        GBeanData storeGBean = bootstrap.addGBean("ConfigStore", configStoreInfo);
        if (configStoreInfo.getReference("Repository") != null) {
            storeGBean.setReferencePattern("Repository", repoGBean.getAbstractName());
        }
        storeNames.add(storeGBean.getAbstractName());
        GBeanInfo targetConfigStoreInfo = GBeanInfo.getGBeanInfo((String)RepositoryConfigurationStore.class.getName(), (ClassLoader)cl);
        GBeanData targetStoreGBean = bootstrap.addGBean("TargetConfigStore", targetConfigStoreInfo);
        if (targetConfigStoreInfo.getReference("Repository") != null) {
            targetStoreGBean.setReferencePattern("Repository", targetRepoGBean.getAbstractName());
        }
        storeNames.add(targetStoreGBean.getAbstractName());
        this.targetConfigStoreAName = targetStoreGBean.getAbstractName();
        this.targetSet = true;
        GBeanData attrManagerGBean = bootstrap.addGBean("AttributeStore", MavenAttributeStore.GBEAN_INFO);
        GBeanData configManagerGBean = bootstrap.addGBean("ConfigManager", KernelConfigurationManager.GBEAN_INFO);
        configManagerGBean.setReferencePatterns("Stores", new ReferencePatterns(storeNames));
        configManagerGBean.setReferencePattern("AttributeStore", attrManagerGBean.getAbstractName());
        configManagerGBean.setReferencePattern("ArtifactManager", artifactManagerGBean.getAbstractName());
        configManagerGBean.setReferencePattern("ArtifactResolver", artifactResolverGBean.getAbstractName());
        configManagerGBean.setReferencePatterns("Repositories", repoPatterns);
        ConfigurationUtil.loadBootstrapConfiguration((Kernel)this.kernel, (ConfigurationData)bootstrap, (ClassLoader)cl);
    }

    private AbstractName locateDeployer(Kernel kernel) {
        AbstractName name = new AbstractName(URI.create(this.deployerName));
        Iterator i = kernel.listGBeans(new AbstractNameQuery(name)).iterator();
        if (!i.hasNext()) {
            throw new IllegalStateException("No deployer found matching deployerName: " + name);
        }
        AbstractName deployer = (AbstractName)i.next();
        if (i.hasNext()) {
            throw new IllegalStateException("Multiple deployers found matching deployerName: " + name);
        }
        return deployer;
    }

    private List invokeDeployer(Kernel kernel, AbstractName deployer, String targetConfigStore) throws Exception {
        Object[] args = new Object[]{Boolean.FALSE, this.moduleFile, this.planFile, null, Boolean.TRUE, null, null, null, null, null, null, null, targetConfigStore};
        return (List)kernel.invoke(deployer, "deploy", args, DEPLOY_SIGNATURE);
    }
}

