/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.plugin.PluginXmlUtil;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyChangeMojo
extends AbstractCarMojo {
    private List<Dependency> dependencies = Collections.emptyList();
    private boolean warnOnDependencyChange;
    private File dependencyFile;
    private File filteredDependencyFile;
    private UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block9: {
            UseMavenDependencies useMavenDependencies = new UseMavenDependencies(true, false, this.useMavenDependencies.isUseTransitiveDependencies());
            try {
                LinkedHashSet<Dependency> dependencies = this.toDependencies(this.dependencies, useMavenDependencies, false);
                if (this.dependencyFile.exists()) {
                    this.filter(this.dependencyFile, this.filteredDependencyFile);
                    FileReader in = new FileReader(this.filteredDependencyFile);
                    try {
                        PluginArtifactType pluginArtifactType = PluginXmlUtil.loadPluginArtifactMetadata((Reader)in);
                        PluginArtifactType removed = new PluginArtifactType();
                        for (DependencyType test : pluginArtifactType.getDependency()) {
                            Dependency testDependency = Dependency.newDependency(test);
                            if (dependencies.remove(testDependency)) continue;
                            removed.getDependency().add(test);
                        }
                        if (!dependencies.isEmpty() || !removed.getDependency().isEmpty()) {
                            this.saveDependencyChanges(dependencies, removed);
                        }
                        break block9;
                    }
                    finally {
                        in.close();
                    }
                }
                this.writeDependencies(this.toPluginArtifactType(dependencies), this.dependencyFile);
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not read or write dependency history info", e);
            }
        }
    }

    protected void saveDependencyChanges(Collection<Dependency> dependencies, PluginArtifactType removed) throws Exception {
        File addedFile = new File(this.dependencyFile.getParentFile(), "dependencies.added.xml");
        PluginArtifactType added = this.toPluginArtifactType(dependencies);
        this.writeDependencies(added, addedFile);
        File removedFile = new File(this.dependencyFile.getParentFile(), "dependencies.removed.xml");
        this.writeDependencies(removed, removedFile);
        File treeListing = this.saveTreeListing();
        StringWriter out = new StringWriter();
        out.write("Dependencies have changed:\n");
        if (!added.getDependency().isEmpty()) {
            out.write("\tAdded dependencies are saved here: " + addedFile.getAbsolutePath() + "\n");
        }
        if (!removed.getDependency().isEmpty()) {
            out.write("\tRemoved dependencies are saved here: " + removedFile.getAbsolutePath() + "\n");
        }
        out.write("\tTree listing is saved here: " + treeListing.getAbsolutePath() + "\n");
        out.write("Delete " + this.dependencyFile.getAbsolutePath() + " if you are happy with the dependency changes.");
        if (!this.warnOnDependencyChange) {
            throw new MojoFailureException(out.toString());
        }
        this.getLog().warn((CharSequence)out.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveTreeListing() throws IOException {
        File treeListFile = new File(this.dependencyFile.getParentFile(), "treeListing.txt");
        FileOutputStream os = new FileOutputStream(treeListFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        try {
            writer.write(this.treeListing);
        }
        finally {
            writer.close();
        }
        return treeListFile;
    }

    private PluginArtifactType toPluginArtifactType(Collection<Dependency> dependencies) throws IOException, XMLStreamException, JAXBException {
        PluginArtifactType pluginArtifactType = new PluginArtifactType();
        for (Dependency dependency : dependencies) {
            pluginArtifactType.getDependency().add(dependency.toDependencyType());
        }
        return pluginArtifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDependencies(PluginArtifactType pluginArtifactType, File file) throws IOException, XMLStreamException, JAXBException {
        pluginArtifactType.setModuleId(this.getModuleId());
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        } else if (!parent.isDirectory()) {
            throw new IOException("expected dependencies history directory is not a directory: " + parent);
        }
        FileWriter out = new FileWriter(file);
        Collections.sort(pluginArtifactType.getDependency(), new Comparator<DependencyType>(){

            @Override
            public int compare(DependencyType a, DependencyType b) {
                int result = a.getGroupId().compareTo(b.getGroupId());
                if (result != 0) {
                    return result;
                }
                result = a.getArtifactId().compareTo(b.getArtifactId());
                if (result != 0) {
                    return result;
                }
                return this.getType(a).compareTo(this.getType(b));
            }

            private String getType(DependencyType a) {
                return a.getType() == null ? "jar" : a.getType();
            }
        });
        try {
            PluginXmlUtil.writePluginArtifact((PluginArtifactType)pluginArtifactType, (Writer)out);
        }
        finally {
            out.close();
        }
    }
}

