/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.mavenplugins.car.Dependency;
import org.apache.geronimo.mavenplugins.car.Maven2RepositoryAdapter;
import org.apache.geronimo.mavenplugins.car.UseMavenDependencies;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCarMojo
extends AbstractLogEnabled
implements Mojo {
    private Log log;
    protected MavenProject project;
    protected File basedir;
    protected Set<org.apache.maven.artifact.Artifact> dependencies;
    protected Set<org.apache.maven.artifact.Artifact> localDependencies;
    private ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    protected String treeListing;
    protected String encoding;
    protected MavenResourcesFiltering mavenResourcesFiltering;
    protected MavenSession session;
    protected String escapeString = "\\";
    protected MavenFileFilter mavenFileFilter;
    protected ArtifactRepository artifactRepository = null;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
    }

    protected void generateExplicitVersionProperties(File outputFile, Set<org.apache.maven.artifact.Artifact> dependencies) throws MojoExecutionException, IOException {
        this.getLog().debug((CharSequence)("Generating explicit version properties: " + outputFile));
        Properties props = new Properties();
        for (org.apache.maven.artifact.Artifact artifact : dependencies) {
            String name = artifact.getGroupId() + "/" + artifact.getArtifactId() + "//" + artifact.getType();
            String value = artifact.getGroupId() + "/" + artifact.getArtifactId() + "/" + artifact.getVersion() + "/" + artifact.getType();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setting " + name + "=" + value));
            }
            props.setProperty(name, value);
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        props.store(output, null);
        output.flush();
        output.close();
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".car");
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.artifact.Artifact artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected Artifact mavenToGeronimoArtifact(org.apache.maven.model.Dependency artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    protected org.apache.maven.artifact.Artifact geronimoToMavenArtifact(Artifact artifact) throws MojoExecutionException {
        assert (artifact != null);
        return this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString(), artifact.getType(), null);
    }

    protected boolean isModuleArtifact(Artifact artifact) {
        assert (artifact != null);
        return "car".equals(artifact.getType());
    }

    protected boolean includeDependency(org.apache.maven.model.Dependency dependency) {
        if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis")) {
            return false;
        }
        String scope = dependency.getScope();
        return scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope);
    }

    protected org.apache.maven.model.Dependency resolveDependency(org.apache.maven.model.Dependency dependency, List<org.apache.maven.model.Dependency> artifacts) {
        for (org.apache.maven.model.Dependency match : artifacts) {
            if (!this.matches(dependency, match)) continue;
            return match;
        }
        throw new IllegalStateException("Dependency " + dependency + " is not resolved in project");
    }

    private boolean matches(org.apache.maven.model.Dependency dependency, org.apache.maven.model.Dependency match) {
        if (dependency.getGroupId() != null && !dependency.getGroupId().equals(match.getGroupId())) {
            return false;
        }
        if (dependency.getArtifactId() != null && !dependency.getArtifactId().equals(match.getArtifactId())) {
            return false;
        }
        return dependency.getType() == null || dependency.getType().equals(match.getType());
    }

    protected void getDependencies(MavenProject project, boolean useTransitiveDependencies) throws MojoExecutionException {
        DependencyNode rootNode;
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener(this.getLogger());
        try {
            Map managedVersions = project.getManagedVersionMap();
            Set dependencyArtifacts = project.getDependencyArtifacts();
            if (dependencyArtifacts == null) {
                dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            }
            ArtifactResolutionResult result = this.artifactCollector.collect(dependencyArtifacts, project.getArtifact(), managedVersions, this.localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
            this.dependencies = result.getArtifacts();
            rootNode = listener.getRootNode();
        }
        catch (ArtifactResolutionException exception) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)exception));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Invalid dependency version for artifact " + project.getArtifact());
        }
        Scanner scanner = new Scanner();
        scanner.scan(rootNode, useTransitiveDependencies);
        this.localDependencies = scanner.localDependencies;
        this.treeListing = scanner.getLog();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.setLog((Log)new SystemStreamLog());
        }
        return this.log;
    }

    protected static org.apache.geronimo.kernel.repository.Dependency toGeronimoDependency(org.apache.maven.artifact.Artifact dependency, boolean includeVersion) {
        Artifact artifact = AbstractCarMojo.toGeronimoArtifact(dependency, includeVersion);
        return new org.apache.geronimo.kernel.repository.Dependency(artifact, ImportType.ALL);
    }

    private static Artifact toGeronimoArtifact(org.apache.maven.artifact.Artifact dependency, boolean includeVersion) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = includeVersion ? dependency.getVersion() : null;
        String type = dependency.getType();
        return new Artifact(groupId, artifactId, version, type);
    }

    protected LinkedHashSet<Dependency> toDependencies(Collection<Dependency> listedDependencies, UseMavenDependencies useMavenDependencies, boolean includeImport) throws InvalidDependencyVersionException, ArtifactResolutionException, ProjectBuildingException, MojoExecutionException {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        if (useMavenDependencies == null || !useMavenDependencies.isValue()) {
            dependencies.addAll(listedDependencies);
        } else {
            HashMap<String, Dependency> explicitDependencyMap = new HashMap<String, Dependency>();
            for (Dependency dependency : listedDependencies) {
                explicitDependencyMap.put(this.getKey(dependency), dependency);
            }
            this.getDependencies(this.project, useMavenDependencies.isUseTransitiveDependencies());
            for (org.apache.maven.artifact.Artifact artifact : this.localDependencies) {
                Dependency explicitDependency = (Dependency)explicitDependencyMap.get(this.getKey(artifact));
                dependencies.add(this.toDependency(artifact, useMavenDependencies.isIncludeVersion(), explicitDependency, includeImport));
            }
        }
        return dependencies;
    }

    private Dependency toDependency(org.apache.maven.artifact.Artifact artifact, boolean includeVersion, Dependency explicitDependency, boolean includeImport) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(includeVersion ? artifact.getVersionRange().getRecommendedVersion().toString() : null);
        dependency.setType(artifact.getType());
        String importType = ImportType.ALL.getName();
        if (includeImport && explicitDependency != null && explicitDependency.getImport() != null) {
            importType = explicitDependency.getImport();
        }
        dependency.setImport(importType);
        if (explicitDependency != null) {
            dependency.setStart(explicitDependency.isStart());
        }
        return dependency;
    }

    private String getKey(Dependency dependency) {
        return dependency.getGroupId() + "/" + dependency.getArtifactId() + "/" + dependency.getType();
    }

    private String getKey(org.apache.maven.artifact.Artifact dependency) {
        return dependency.getGroupId() + "/" + dependency.getArtifactId() + "/" + dependency.getType();
    }

    protected ArtifactType getModuleId() {
        ArtifactType artifactType = new ArtifactType();
        artifactType.setGroupId(this.project.getGroupId());
        artifactType.setArtifactId(this.project.getArtifactId());
        artifactType.setVersion(this.project.getVersion());
        artifactType.setType(this.project.getArtifact().getType());
        return artifactType;
    }

    protected org.apache.maven.artifact.Artifact resolveArtifact(String groupId, String artifactId, String type) {
        for (org.apache.maven.artifact.Artifact artifact : this.dependencies) {
            if (!this.matches(groupId, artifactId, type, artifact)) continue;
            return artifact;
        }
        return null;
    }

    private boolean matches(String groupId, String artifactId, String type, org.apache.maven.artifact.Artifact artifact) {
        if (!groupId.equals(artifact.getGroupId())) {
            return false;
        }
        if (!artifactId.equals(artifact.getArtifactId())) {
            return false;
        }
        return type.equals(artifact.getType());
    }

    protected void filter(File sourceFile, File targetFile) throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            targetFile.getParentFile().mkdirs();
            List filters = this.mavenFileFilter.getDefaultFilterWrappers(this.project, null, true, this.session, null);
            this.mavenFileFilter.copyFile(sourceFile, targetFile, true, filters, this.encoding, true);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected class ArtifactLookupImpl
    implements Maven2RepositoryAdapter.ArtifactLookup {
        protected ArtifactLookupImpl() {
        }

        public File getBasedir() {
            String path = AbstractCarMojo.this.getArtifactRepository().getBasedir();
            return new File(path);
        }

        private boolean isProjectArtifact(Artifact artifact) {
            MavenProject project = AbstractCarMojo.this.getProject();
            return artifact.getGroupId().equals(project.getGroupId()) && artifact.getArtifactId().equals(project.getArtifactId());
        }

        public File getLocation(Artifact artifact) {
            org.apache.maven.artifact.Artifact mavenArtifact;
            assert (artifact != null);
            if (this.isProjectArtifact(artifact) && artifact.getVersion() == null) {
                throw new IllegalStateException("WTF? project has no version??");
            }
            if (artifact.getVersion() == null) {
                if (AbstractCarMojo.this.log.isDebugEnabled()) {
                    AbstractCarMojo.this.getLog().debug((CharSequence)("Resolving artifact: " + artifact));
                }
                mavenArtifact = AbstractCarMojo.this.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType());
            } else {
                mavenArtifact = AbstractCarMojo.this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString(), artifact.getType(), null);
            }
            String path = AbstractCarMojo.this.getArtifactRepository().pathOf(mavenArtifact);
            return new File(this.getBasedir(), path);
        }
    }

    private static class Scanner {
        private final Set<org.apache.maven.artifact.Artifact> localDependencies = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        private final Set<org.apache.maven.artifact.Artifact> carDependencies = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
        private final StringBuilder log = new StringBuilder();

        private Scanner() {
        }

        public void scan(DependencyNode rootNode, boolean useTransitiveDependencies) {
            for (DependencyNode child : rootNode.getChildren()) {
                this.scan(child, Accept.ACCEPT, useTransitiveDependencies, false, "");
            }
            if (useTransitiveDependencies) {
                this.localDependencies.removeAll(this.carDependencies);
            }
        }

        private void scan(DependencyNode rootNode, Accept parentAccept, boolean useTransitiveDependencies, boolean isFromCar, String indent) {
            org.apache.maven.artifact.Artifact artifact = this.getArtifact(rootNode);
            Accept accept = this.accept(artifact, parentAccept);
            if (accept.isContinue()) {
                if (isFromCar) {
                    if (!artifact.getType().equals("car")) {
                        this.log.append(indent).append("from car:").append(artifact).append("\n");
                        this.carDependencies.add(artifact);
                    } else {
                        this.log.append(indent).append("is car:").append(artifact).append("\n");
                    }
                } else {
                    this.log.append(indent).append("local:").append(artifact).append("\n");
                    if (this.carDependencies.contains(artifact)) {
                        this.log.append(indent).append("already in car, returning:").append(artifact).append("\n");
                        return;
                    }
                    this.localDependencies.add(artifact);
                    if (artifact.getType().equals("car") || !useTransitiveDependencies) {
                        isFromCar = true;
                    }
                }
                for (DependencyNode child : rootNode.getChildren()) {
                    this.scan(child, accept, useTransitiveDependencies, isFromCar, indent + "  ");
                }
            }
        }

        public String getLog() {
            return this.log.toString();
        }

        private org.apache.maven.artifact.Artifact getArtifact(DependencyNode rootNode) {
            org.apache.maven.artifact.Artifact artifact = rootNode.getArtifact();
            if (rootNode.getRelatedArtifact() != null) {
                artifact = rootNode.getRelatedArtifact();
            }
            return artifact;
        }

        private Accept accept(org.apache.maven.artifact.Artifact dependency, Accept previous) {
            if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis")) {
                return Accept.STOP;
            }
            String scope = dependency.getScope();
            if (scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope)) {
                return previous;
            }
            return Accept.STOP;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Accept {
            ACCEPT(true, true),
            PROVIDED(true, false),
            STOP(false, false);

            private final boolean more;
            private final boolean local;

            private Accept(boolean more, boolean local) {
                this.more = more;
                this.local = local;
            }

            public boolean isContinue() {
                return this.more;
            }

            public boolean isLocal() {
                return this.local;
            }
        }
    }
}

