/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConfigStore
extends RepositoryConfigurationStore {
    public static final GBeanInfo GBEAN_INFO;

    public MavenConfigStore(Kernel kernel, String objectName, WritableListableRepository repository) {
        super(kernel, objectName, null, repository);
    }

    public MavenConfigStore(WritableListableRepository repository) {
        super(repository);
    }

    public File createNewConfigurationDir(Artifact configId) {
        try {
            File tmpFile = File.createTempFile("package", ".tmpdir");
            tmpFile.delete();
            tmpFile.mkdir();
            if (!tmpFile.isDirectory()) {
                return null;
            }
            File metaInf = new File(tmpFile, "META-INF");
            metaInf.mkdirs();
            return tmpFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void install(ConfigurationData configurationData) throws IOException, InvalidConfigException {
        File source = configurationData.getConfigurationDir();
        if (!source.isDirectory()) {
            throw new InvalidConfigException("Source must be a directory: " + source);
        }
        Artifact configId = configurationData.getId();
        File targetFile = this.repository.getLocation(configId);
        ExecutableConfigurationUtil.createExecutableConfiguration((ConfigurationData)configurationData, null, (File)targetFile);
    }

    public void uninstall(Artifact configID) throws NoSuchConfigException, IOException {
        File targetFile = this.repository.getLocation(configID);
        targetFile.delete();
    }

    public List<ConfigurationInfo> listConfigurations() {
        throw new UnsupportedOperationException();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(MavenConfigStore.class, (String)"ConfigurationStore");
        builder.addAttribute("kernel", Kernel.class, false);
        builder.addAttribute("objectName", String.class, false);
        builder.addReference("Repository", WritableListableRepository.class, "Repository");
        builder.setConstructor(new String[]{"kernel", "objectName", "Repository"});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

