/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public class InstallArtifactsMojo
extends AbstractCarMojo {
    private File repositoryDirectory = null;
    private ArtifactItem[] artifacts = null;
    private boolean force = true;

    protected void doExecute() throws Exception {
        if (!this.repositoryDirectory.exists()) {
            this.repositoryDirectory.mkdirs();
            this.log.info((CharSequence)("Created directory: " + this.repositoryDirectory));
        } else if (!this.repositoryDirectory.isDirectory()) {
            throw new MojoExecutionException("Invalid reposiory directory: " + this.repositoryDirectory);
        }
        Maven2Repository repository = new Maven2Repository(this.repositoryDirectory);
        for (int i = 0; i < this.artifacts.length; ++i) {
            org.apache.maven.artifact.Artifact artifact = this.getArtifact(this.artifacts[i]);
            this.log.info((CharSequence)("Installing: " + artifact));
            Artifact gartifact = this.mavenArtifactToGeronimo(artifact);
            if (repository.contains(gartifact)) {
                if (this.force) {
                    File file = repository.getLocation(gartifact);
                    this.log.debug((CharSequence)("Force deletion of: " + file));
                    if (!file.delete()) {
                        throw new MojoExecutionException("Failed to delete artifact from repository: " + this.artifacts[i]);
                    }
                } else {
                    throw new MojoExecutionException("Artifact already exists in repository: " + this.artifacts[i]);
                }
            }
            repository.copyToRepository(artifact.getFile(), gartifact, null);
        }
    }

    private Artifact mavenArtifactToGeronimo(org.apache.maven.artifact.Artifact artifact) {
        assert (artifact != null);
        return new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }
}

