/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.car;

import java.io.File;
import org.apache.geronimo.mavenplugins.car.AbstractCarMojo;
import org.apache.geronimo.mavenplugins.car.ClasspathElement;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class ArchiveCarMojo
extends AbstractCarMojo {
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private JarArchiver jarArchiver = null;
    private File baseDirectory = null;
    private File outputDirectory = null;
    private File classesDirectory = null;
    private String finalName = null;
    private File targetRepository = null;
    private File explicitResolutionProperties = null;
    private ClasspathElement[] classpath = null;
    private String classpathPrefix = null;
    private File resourcesDir;

    protected void doExecute() throws Exception {
        File archive = this.createArchive();
        this.project.getArtifact().setFile(archive);
    }

    private File getArtifactInRepositoryDir() {
        File dir = new File(this.targetRepository, this.project.getGroupId().replace('.', '/'));
        dir = new File(dir, this.project.getArtifactId());
        dir = new File(dir, this.project.getVersion());
        dir = new File(dir, this.project.getArtifactId() + "-" + this.project.getVersion() + ".car");
        return dir;
    }

    private File createArchive() throws MojoExecutionException {
        File archiveFile = ArchiveCarMojo.getArchiveFile(this.outputDirectory, this.finalName, null);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            archiver.getArchiver().addDirectory(this.getArtifactInRepositoryDir());
            if (this.classesDirectory.isDirectory()) {
                archiver.getArchiver().addDirectory(this.classesDirectory);
            }
            if (this.resourcesDir.isDirectory()) {
                archiver.getArchiver().addDirectory(this.resourcesDir);
            }
            String[] includes = new String[]{"LICENSE.txt", "LICENSE", "NOTICE.txt", "NOTICE", "DISCLAIMER.txt", "DISCLAIMER"};
            archiver.getArchiver().addDirectory(this.baseDirectory, "META-INF/", includes, new String[0]);
            if (this.classpath != null) {
                this.archive.addManifestEntry((Object)"Class-Path", (Object)this.getClassPath());
            }
            archiver.createArchive(this.project, this.archive);
            return archiveFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create archive", e);
        }
    }

    private String getClassPath() throws MojoExecutionException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.classpath.length; ++i) {
            String entry = this.classpath[i].getEntry();
            if (entry != null) {
                buff.append(entry);
            } else {
                Artifact artifact = this.getArtifact(this.classpath[i]);
                String prefix = this.classpath[i].getClasspathPrefix();
                if (prefix == null) {
                    prefix = this.classpathPrefix;
                }
                if (prefix != null) {
                    buff.append(prefix);
                    if (!prefix.endsWith("/")) {
                        buff.append("/");
                    }
                }
                File file = artifact.getFile();
                buff.append(file.getName());
            }
            if (i + 1 >= this.classpath.length) continue;
            buff.append(" ");
        }
        this.log.debug((CharSequence)("Using classpath: " + buff));
        return buff.toString();
    }
}

